/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.changefeed.BlobChangefeedAsyncClient;
import com.azure.storage.blob.changefeed.BlobChangefeedClient;
import com.azure.storage.blob.changefeed.BlobChunkedDownloaderFactory;
import com.azure.storage.blob.changefeed.ChangefeedFactory;
import com.azure.storage.blob.changefeed.ChunkFactory;
import com.azure.storage.blob.changefeed.SegmentFactory;
import com.azure.storage.blob.changefeed.ShardFactory;
import com.azure.storage.blob.implementation.util.BlobUserAgentModificationPolicy;
import com.azure.storage.internal.avro.implementation.AvroReaderFactory;
import java.util.ArrayList;
import java.util.Map;

@ServiceClientBuilder(serviceClients={BlobChangefeedClient.class, BlobChangefeedAsyncClient.class})
public final class BlobChangefeedClientBuilder {
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties("azure-storage-blob-changefeed.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");
    static final String CHANGEFEED_CONTAINER_NAME = "$blobchangefeed";
    private final String accountUrl;
    private final HttpPipeline pipeline;
    private final BlobServiceVersion version;

    public BlobChangefeedClientBuilder(BlobServiceClient client) {
        this.accountUrl = client.getAccountUrl();
        this.pipeline = client.getHttpPipeline();
        this.version = client.getServiceVersion();
    }

    public BlobChangefeedClientBuilder(BlobServiceAsyncClient client) {
        this.accountUrl = client.getAccountUrl();
        this.pipeline = client.getHttpPipeline();
        this.version = client.getServiceVersion();
    }

    public BlobChangefeedClient buildClient() {
        return new BlobChangefeedClient(this.buildAsyncClient());
    }

    public BlobChangefeedAsyncClient buildAsyncClient() {
        BlobContainerAsyncClient client = new BlobContainerClientBuilder().endpoint(this.accountUrl).containerName(CHANGEFEED_CONTAINER_NAME).pipeline(this.addBlobUserAgentModificationPolicy(this.pipeline)).serviceVersion(this.version).buildAsyncClient();
        AvroReaderFactory avroReaderFactory = new AvroReaderFactory();
        BlobChunkedDownloaderFactory blobChunkedDownloaderFactory = new BlobChunkedDownloaderFactory(client);
        ChunkFactory chunkFactory = new ChunkFactory(avroReaderFactory, blobChunkedDownloaderFactory);
        ShardFactory shardFactory = new ShardFactory(chunkFactory, client);
        SegmentFactory segmentFactory = new SegmentFactory(shardFactory, client);
        ChangefeedFactory changefeedFactory = new ChangefeedFactory(segmentFactory, client);
        return new BlobChangefeedAsyncClient(changefeedFactory);
    }

    private HttpPipeline addBlobUserAgentModificationPolicy(HttpPipeline pipeline) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            HttpPipelinePolicy currPolicy = pipeline.getPolicy(i);
            policies.add(currPolicy);
            if (!(currPolicy instanceof UserAgentPolicy)) continue;
            policies.add(new BlobUserAgentModificationPolicy(CLIENT_NAME, CLIENT_VERSION));
        }
        return new HttpPipelineBuilder().httpClient(pipeline.getHttpClient()).policies(policies.toArray(new HttpPipelinePolicy[0])).tracer(pipeline.getTracer()).build();
    }
}

