/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.changefeed.BlobChunkedDownloader;
import com.azure.storage.common.implementation.StorageImplUtils;

class BlobChunkedDownloaderFactory {
    private final BlobContainerAsyncClient client;

    BlobChunkedDownloaderFactory(BlobContainerAsyncClient client) {
        StorageImplUtils.assertNotNull("client", client);
        this.client = client;
    }

    BlobChunkedDownloader getBlobLazyDownloader(String blobPath, long blockSize, long offset) {
        StorageImplUtils.assertNotNull("blobPath", blobPath);
        BlobAsyncClient blobClient = this.client.getBlobAsyncClient(blobPath);
        return new BlobChunkedDownloader(blobClient, blockSize, offset);
    }

    BlobChunkedDownloader getBlobLazyDownloader(String blobPath, long totalSize) {
        StorageImplUtils.assertNotNull("blobPath", blobPath);
        BlobAsyncClient blobClient = this.client.getBlobAsyncClient(blobPath);
        return new BlobChunkedDownloader(blobClient, totalSize);
    }
}

