/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.changefeed.Segment;
import com.azure.storage.blob.changefeed.ShardFactory;
import com.azure.storage.blob.changefeed.implementation.models.ChangefeedCursor;
import com.azure.storage.blob.changefeed.implementation.models.SegmentCursor;
import com.azure.storage.common.implementation.StorageImplUtils;

class SegmentFactory {
    private final ShardFactory shardFactory;
    private final BlobContainerAsyncClient client;

    SegmentFactory(ShardFactory shardFactory, BlobContainerAsyncClient client) {
        StorageImplUtils.assertNotNull("shardFactory", shardFactory);
        StorageImplUtils.assertNotNull("client", client);
        this.shardFactory = shardFactory;
        this.client = client;
    }

    Segment getSegment(String segmentPath, ChangefeedCursor changefeedCursor, SegmentCursor userCursor) {
        StorageImplUtils.assertNotNull("segmentPath", segmentPath);
        StorageImplUtils.assertNotNull("changefeedCursor", changefeedCursor);
        return new Segment(this.client, segmentPath, changefeedCursor, userCursor, this.shardFactory);
    }
}

