/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.util;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.storage.blob.BlobContainerAsyncClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import reactor.core.publisher.Mono;

public class DownloadUtils {
    private static final ClientLogger LOGGER = new ClientLogger(DownloadUtils.class);

    public static Mono<byte[]> downloadToByteArray(BlobContainerAsyncClient client, String blobPath) {
        return FluxUtil.collectBytesInByteBufferStream(client.getBlobAsyncClient(blobPath).download());
    }

    public static Mono<Map<String, Object>> parseJson(byte[] json) {
        Mono<Map<String, Object>> mono;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader(json);
            try {
                mono = Mono.just(jsonReader.readMap(JsonReader::readUntyped));
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return FluxUtil.monoError(LOGGER, (RuntimeException)new UncheckedIOException(e));
                }
            }
            jsonReader.close();
        }
        return mono;
    }
}

