/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlockBlobsCommitBlockListHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsGetBlockListHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsPutBlobFromUrlHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsStageBlockFromURLHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsStageBlockHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsUploadHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobCopySourceTagsMode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.BlockLookupList;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BlockBlobsImpl {
    private final BlockBlobsService service;
    private final AzureBlobStorageImpl client;

    BlockBlobsImpl(AzureBlobStorageImpl client) {
        this.service = RestProxy.create(BlockBlobsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil.withContext(context -> this.service.upload(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.upload(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return this.uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return this.uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil.withContext(context -> this.service.uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil.withContext(context -> this.service.upload(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.upload(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return this.uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return this.uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil.withContext(context -> this.service.uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void>> putBlobFromUrlWithResponseAsync(String containerName, String blob, long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return FluxUtil.withContext(context -> this.service.putBlobFromUrl(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource, copySourceBlobProperties, copySourceAuthorization, copySourceTags, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void>> putBlobFromUrlWithResponseAsync(String containerName, String blob, long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return this.service.putBlobFromUrl(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource, copySourceBlobProperties, copySourceAuthorization, copySourceTags, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> putBlobFromUrlAsync(String containerName, String blob, long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return this.putBlobFromUrlWithResponseAsync(containerName, blob, contentLength, copySource, timeout, transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, requestId, sourceContentMD5, blobTagsString, copySourceBlobProperties, copySourceAuthorization, copySourceTags, blobHttpHeaders, cpkInfo, encryptionScopeParam).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> putBlobFromUrlAsync(String containerName, String blob, long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return this.putBlobFromUrlWithResponseAsync(containerName, blob, contentLength, copySource, timeout, transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, requestId, sourceContentMD5, blobTagsString, copySourceBlobProperties, copySourceAuthorization, copySourceTags, blobHttpHeaders, cpkInfo, encryptionScopeParam, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> putBlobFromUrlNoCustomHeadersWithResponseAsync(String containerName, String blob, long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return FluxUtil.withContext(context -> this.service.putBlobFromUrlNoCustomHeaders(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource, copySourceBlobProperties, copySourceAuthorization, copySourceTags, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> putBlobFromUrlNoCustomHeadersWithResponseAsync(String containerName, String blob, long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String blobType = "BlockBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return this.service.putBlobFromUrlNoCustomHeaders(this.client.getUrl(), containerName, blob, "BlockBlob", timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource, copySourceBlobProperties, copySourceAuthorization, copySourceTags, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.stageBlock(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.stageBlock(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return this.stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5, transactionalContentCrc64, timeout, leaseId, requestId, cpkInfo, encryptionScopeParam).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return this.stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5, transactionalContentCrc64, timeout, leaseId, requestId, cpkInfo, encryptionScopeParam, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.stageBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.stageBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName, String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.stageBlock(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName, String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.stageBlock(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return this.stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5, transactionalContentCrc64, timeout, leaseId, requestId, cpkInfo, encryptionScopeParam).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return this.stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5, transactionalContentCrc64, timeout, leaseId, requestId, cpkInfo, encryptionScopeParam, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.stageBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.stageBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void>> stageBlockFromURLWithResponseAsync(String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.stageBlockFromURL(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void>> stageBlockFromURLWithResponseAsync(String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.stageBlockFromURL(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlockFromURLAsync(String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return this.stageBlockFromURLWithResponseAsync(containerName, blob, blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5, sourceContentcrc64, timeout, leaseId, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo, encryptionScopeParam).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlockFromURLAsync(String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return this.stageBlockFromURLWithResponseAsync(containerName, blob, blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5, sourceContentcrc64, timeout, leaseId, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo, encryptionScopeParam, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockFromURLNoCustomHeadersWithResponseAsync(String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.stageBlockFromURLNoCustomHeaders(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockFromURLNoCustomHeadersWithResponseAsync(String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "block";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.stageBlockFromURLNoCustomHeaders(this.client.getUrl(), containerName, blob, "block", blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsCommitBlockListHeaders, Void>> commitBlockListWithResponseAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "blocklist";
        String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil.withContext(context -> this.service.commitBlockList(this.client.getUrl(), containerName, blob, "blocklist", timeout, cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted, transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, blocks, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsCommitBlockListHeaders, Void>> commitBlockListWithResponseAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "blocklist";
        String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.commitBlockList(this.client.getUrl(), containerName, blob, "blocklist", timeout, cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted, transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, blocks, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> commitBlockListAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return this.commitBlockListWithResponseAsync(containerName, blob, blocks, timeout, transactionalContentMD5, transactionalContentCrc64, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> commitBlockListAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return this.commitBlockListWithResponseAsync(containerName, blob, blocks, timeout, transactionalContentMD5, transactionalContentCrc64, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> commitBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        String comp = "blocklist";
        String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil.withContext(context -> this.service.commitBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob, "blocklist", timeout, cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted, transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, blocks, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> commitBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "blocklist";
        String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.commitBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob, "blocklist", timeout, cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted, transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, blocks, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsGetBlockListHeaders, BlockList>> getBlockListWithResponseAsync(String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId) {
        String comp = "blocklist";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getBlockList(this.client.getUrl(), containerName, blob, "blocklist", snapshot, listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsGetBlockListHeaders, BlockList>> getBlockListWithResponseAsync(String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId, Context context) {
        String comp = "blocklist";
        String accept = "application/xml";
        return this.service.getBlockList(this.client.getUrl(), containerName, blob, "blocklist", snapshot, listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockList> getBlockListAsync(String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId) {
        return this.getBlockListWithResponseAsync(containerName, blob, listType, snapshot, timeout, leaseId, ifTags, requestId).flatMap(res -> Mono.justOrEmpty((BlockList)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockList> getBlockListAsync(String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId, Context context) {
        return this.getBlockListWithResponseAsync(containerName, blob, listType, snapshot, timeout, leaseId, ifTags, requestId, context).flatMap(res -> Mono.justOrEmpty((BlockList)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockList>> getBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId) {
        String comp = "blocklist";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob, "blocklist", snapshot, listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockList>> getBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId, Context context) {
        String comp = "blocklist";
        String accept = "application/xml";
        return this.service.getBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob, "blocklist", snapshot, listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageBloc")
    public static interface BlockBlobsService {
        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> upload(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-blob-type") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-MD5") String var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="x-ms-blob-content-type") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-md5") String var12, @HeaderParam(value="x-ms-blob-cache-control") String var13, @HeaderParam(value="x-ms-meta-") Map<String, String> var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-encryption-key") String var17, @HeaderParam(value="x-ms-encryption-key-sha256") String var18, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var19, @HeaderParam(value="x-ms-encryption-scope") String var20, @HeaderParam(value="x-ms-access-tier") AccessTier var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Match") String var24, @HeaderParam(value="If-None-Match") String var25, @HeaderParam(value="x-ms-if-tags") String var26, @HeaderParam(value="x-ms-version") String var27, @HeaderParam(value="x-ms-client-request-id") String var28, @HeaderParam(value="x-ms-tags") String var29, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var30, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var31, @HeaderParam(value="x-ms-legal-hold") Boolean var32, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var33, @HeaderParam(value="Accept") String var34, Context var35);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> uploadNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-blob-type") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-MD5") String var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="x-ms-blob-content-type") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-md5") String var12, @HeaderParam(value="x-ms-blob-cache-control") String var13, @HeaderParam(value="x-ms-meta-") Map<String, String> var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-encryption-key") String var17, @HeaderParam(value="x-ms-encryption-key-sha256") String var18, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var19, @HeaderParam(value="x-ms-encryption-scope") String var20, @HeaderParam(value="x-ms-access-tier") AccessTier var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Match") String var24, @HeaderParam(value="If-None-Match") String var25, @HeaderParam(value="x-ms-if-tags") String var26, @HeaderParam(value="x-ms-version") String var27, @HeaderParam(value="x-ms-client-request-id") String var28, @HeaderParam(value="x-ms-tags") String var29, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var30, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var31, @HeaderParam(value="x-ms-legal-hold") Boolean var32, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var33, @HeaderParam(value="Accept") String var34, Context var35);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> upload(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-blob-type") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-MD5") String var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="x-ms-blob-content-type") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-md5") String var12, @HeaderParam(value="x-ms-blob-cache-control") String var13, @HeaderParam(value="x-ms-meta-") Map<String, String> var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-encryption-key") String var17, @HeaderParam(value="x-ms-encryption-key-sha256") String var18, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var19, @HeaderParam(value="x-ms-encryption-scope") String var20, @HeaderParam(value="x-ms-access-tier") AccessTier var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Match") String var24, @HeaderParam(value="If-None-Match") String var25, @HeaderParam(value="x-ms-if-tags") String var26, @HeaderParam(value="x-ms-version") String var27, @HeaderParam(value="x-ms-client-request-id") String var28, @HeaderParam(value="x-ms-tags") String var29, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var30, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var31, @HeaderParam(value="x-ms-legal-hold") Boolean var32, @BodyParam(value="application/octet-stream") BinaryData var33, @HeaderParam(value="Accept") String var34, Context var35);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> uploadNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-blob-type") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-MD5") String var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="x-ms-blob-content-type") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-md5") String var12, @HeaderParam(value="x-ms-blob-cache-control") String var13, @HeaderParam(value="x-ms-meta-") Map<String, String> var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-encryption-key") String var17, @HeaderParam(value="x-ms-encryption-key-sha256") String var18, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var19, @HeaderParam(value="x-ms-encryption-scope") String var20, @HeaderParam(value="x-ms-access-tier") AccessTier var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Match") String var24, @HeaderParam(value="If-None-Match") String var25, @HeaderParam(value="x-ms-if-tags") String var26, @HeaderParam(value="x-ms-version") String var27, @HeaderParam(value="x-ms-client-request-id") String var28, @HeaderParam(value="x-ms-tags") String var29, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var30, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var31, @HeaderParam(value="x-ms-legal-hold") Boolean var32, @BodyParam(value="application/octet-stream") BinaryData var33, @HeaderParam(value="Accept") String var34, Context var35);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void>> putBlobFromUrl(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-blob-type") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-MD5") String var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="x-ms-blob-content-type") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-md5") String var12, @HeaderParam(value="x-ms-blob-cache-control") String var13, @HeaderParam(value="x-ms-meta-") Map<String, String> var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-encryption-key") String var17, @HeaderParam(value="x-ms-encryption-key-sha256") String var18, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var19, @HeaderParam(value="x-ms-encryption-scope") String var20, @HeaderParam(value="x-ms-access-tier") AccessTier var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Match") String var24, @HeaderParam(value="If-None-Match") String var25, @HeaderParam(value="x-ms-if-tags") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-source-if-match") String var29, @HeaderParam(value="x-ms-source-if-none-match") String var30, @HeaderParam(value="x-ms-source-if-tags") String var31, @HeaderParam(value="x-ms-version") String var32, @HeaderParam(value="x-ms-client-request-id") String var33, @HeaderParam(value="x-ms-source-content-md5") String var34, @HeaderParam(value="x-ms-tags") String var35, @HeaderParam(value="x-ms-copy-source") String var36, @HeaderParam(value="x-ms-copy-source-blob-properties") Boolean var37, @HeaderParam(value="x-ms-copy-source-authorization") String var38, @HeaderParam(value="x-ms-copy-source-tag-option") BlobCopySourceTagsMode var39, @HeaderParam(value="Accept") String var40, Context var41);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> putBlobFromUrlNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-blob-type") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-MD5") String var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="x-ms-blob-content-type") String var9, @HeaderParam(value="x-ms-blob-content-encoding") String var10, @HeaderParam(value="x-ms-blob-content-language") String var11, @HeaderParam(value="x-ms-blob-content-md5") String var12, @HeaderParam(value="x-ms-blob-cache-control") String var13, @HeaderParam(value="x-ms-meta-") Map<String, String> var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-encryption-key") String var17, @HeaderParam(value="x-ms-encryption-key-sha256") String var18, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var19, @HeaderParam(value="x-ms-encryption-scope") String var20, @HeaderParam(value="x-ms-access-tier") AccessTier var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Match") String var24, @HeaderParam(value="If-None-Match") String var25, @HeaderParam(value="x-ms-if-tags") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-source-if-match") String var29, @HeaderParam(value="x-ms-source-if-none-match") String var30, @HeaderParam(value="x-ms-source-if-tags") String var31, @HeaderParam(value="x-ms-version") String var32, @HeaderParam(value="x-ms-client-request-id") String var33, @HeaderParam(value="x-ms-source-content-md5") String var34, @HeaderParam(value="x-ms-tags") String var35, @HeaderParam(value="x-ms-copy-source") String var36, @HeaderParam(value="x-ms-copy-source-blob-properties") Boolean var37, @HeaderParam(value="x-ms-copy-source-authorization") String var38, @HeaderParam(value="x-ms-copy-source-tag-option") BlobCopySourceTagsMode var39, @HeaderParam(value="Accept") String var40, Context var41);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlock(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="blockid") String var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-encryption-key") String var12, @HeaderParam(value="x-ms-encryption-key-sha256") String var13, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var14, @HeaderParam(value="x-ms-encryption-scope") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> stageBlockNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="blockid") String var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-encryption-key") String var12, @HeaderParam(value="x-ms-encryption-key-sha256") String var13, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var14, @HeaderParam(value="x-ms-encryption-scope") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlock(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="blockid") String var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-encryption-key") String var12, @HeaderParam(value="x-ms-encryption-key-sha256") String var13, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var14, @HeaderParam(value="x-ms-encryption-scope") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @BodyParam(value="application/octet-stream") BinaryData var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> stageBlockNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="blockid") String var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-encryption-key") String var12, @HeaderParam(value="x-ms-encryption-key-sha256") String var13, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var14, @HeaderParam(value="x-ms-encryption-scope") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @BodyParam(value="application/octet-stream") BinaryData var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void>> stageBlockFromURL(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="blockid") String var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="x-ms-copy-source") String var8, @HeaderParam(value="x-ms-source-range") String var9, @HeaderParam(value="x-ms-source-content-md5") String var10, @HeaderParam(value="x-ms-source-content-crc64") String var11, @QueryParam(value="timeout") Integer var12, @HeaderParam(value="x-ms-encryption-key") String var13, @HeaderParam(value="x-ms-encryption-key-sha256") String var14, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var15, @HeaderParam(value="x-ms-encryption-scope") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var18, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var19, @HeaderParam(value="x-ms-source-if-match") String var20, @HeaderParam(value="x-ms-source-if-none-match") String var21, @HeaderParam(value="x-ms-version") String var22, @HeaderParam(value="x-ms-client-request-id") String var23, @HeaderParam(value="x-ms-copy-source-authorization") String var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> stageBlockFromURLNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="blockid") String var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="x-ms-copy-source") String var8, @HeaderParam(value="x-ms-source-range") String var9, @HeaderParam(value="x-ms-source-content-md5") String var10, @HeaderParam(value="x-ms-source-content-crc64") String var11, @QueryParam(value="timeout") Integer var12, @HeaderParam(value="x-ms-encryption-key") String var13, @HeaderParam(value="x-ms-encryption-key-sha256") String var14, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var15, @HeaderParam(value="x-ms-encryption-scope") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var18, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var19, @HeaderParam(value="x-ms-source-if-match") String var20, @HeaderParam(value="x-ms-source-if-none-match") String var21, @HeaderParam(value="x-ms-version") String var22, @HeaderParam(value="x-ms-client-request-id") String var23, @HeaderParam(value="x-ms-copy-source-authorization") String var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsCommitBlockListHeaders, Void>> commitBlockList(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-blob-cache-control") String var6, @HeaderParam(value="x-ms-blob-content-type") String var7, @HeaderParam(value="x-ms-blob-content-encoding") String var8, @HeaderParam(value="x-ms-blob-content-language") String var9, @HeaderParam(value="x-ms-blob-content-md5") String var10, @HeaderParam(value="Content-MD5") String var11, @HeaderParam(value="x-ms-content-crc64") String var12, @HeaderParam(value="x-ms-meta-") Map<String, String> var13, @HeaderParam(value="x-ms-lease-id") String var14, @HeaderParam(value="x-ms-blob-content-disposition") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @HeaderParam(value="x-ms-encryption-scope") String var19, @HeaderParam(value="x-ms-access-tier") AccessTier var20, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Match") String var23, @HeaderParam(value="If-None-Match") String var24, @HeaderParam(value="x-ms-if-tags") String var25, @HeaderParam(value="x-ms-version") String var26, @HeaderParam(value="x-ms-client-request-id") String var27, @HeaderParam(value="x-ms-tags") String var28, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var29, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var30, @HeaderParam(value="x-ms-legal-hold") Boolean var31, @BodyParam(value="application/xml") BlockLookupList var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> commitBlockListNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-blob-cache-control") String var6, @HeaderParam(value="x-ms-blob-content-type") String var7, @HeaderParam(value="x-ms-blob-content-encoding") String var8, @HeaderParam(value="x-ms-blob-content-language") String var9, @HeaderParam(value="x-ms-blob-content-md5") String var10, @HeaderParam(value="Content-MD5") String var11, @HeaderParam(value="x-ms-content-crc64") String var12, @HeaderParam(value="x-ms-meta-") Map<String, String> var13, @HeaderParam(value="x-ms-lease-id") String var14, @HeaderParam(value="x-ms-blob-content-disposition") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @HeaderParam(value="x-ms-encryption-scope") String var19, @HeaderParam(value="x-ms-access-tier") AccessTier var20, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Match") String var23, @HeaderParam(value="If-None-Match") String var24, @HeaderParam(value="x-ms-if-tags") String var25, @HeaderParam(value="x-ms-version") String var26, @HeaderParam(value="x-ms-client-request-id") String var27, @HeaderParam(value="x-ms-tags") String var28, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var29, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var30, @HeaderParam(value="x-ms-legal-hold") Boolean var31, @BodyParam(value="application/xml") BlockLookupList var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Get(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<BlockBlobsGetBlockListHeaders, BlockList>> getBlockList(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="snapshot") String var5, @QueryParam(value="blocklisttype") BlockListType var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-if-tags") String var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<BlockList>> getBlockListNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="snapshot") String var5, @QueryParam(value="blocklisttype") BlockListType var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-if-tags") String var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);
    }
}

