/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Base64;

@JacksonXmlRootElement(localName="null")
public final class PageBlobsUploadPagesHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="x-ms-content-crc64")
    private byte[] xMsContentCrc64;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long xMsBlobSequenceNumber;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String xMsEncryptionKeySha256;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-request-server-encrypted")
    private Boolean xMsRequestServerEncrypted;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="x-ms-encryption-scope")
    private String xMsEncryptionScope;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");
    private static final HttpHeaderName X_MS_CONTENT_CRC64 = HttpHeaderName.fromString("x-ms-content-crc64");
    private static final HttpHeaderName X_MS_BLOB_SEQUENCE_NUMBER = HttpHeaderName.fromString("x-ms-blob-sequence-number");
    private static final HttpHeaderName X_MS_ENCRYPTION_KEY_SHA256 = HttpHeaderName.fromString("x-ms-encryption-key-sha256");
    private static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString("x-ms-request-id");
    private static final HttpHeaderName X_MS_REQUEST_SERVER_ENCRYPTED = HttpHeaderName.fromString("x-ms-request-server-encrypted");
    private static final HttpHeaderName X_MS_ENCRYPTION_SCOPE = HttpHeaderName.fromString("x-ms-encryption-scope");

    public PageBlobsUploadPagesHeaders(HttpHeaders rawHeaders) {
        String contentMD5;
        String lastModified;
        String xMsBlobSequenceNumber;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsContentCrc64 = rawHeaders.getValue(X_MS_CONTENT_CRC64);
        if (xMsContentCrc64 != null) {
            this.xMsContentCrc64 = Base64.getDecoder().decode(xMsContentCrc64);
        }
        if ((xMsBlobSequenceNumber = rawHeaders.getValue(X_MS_BLOB_SEQUENCE_NUMBER)) != null) {
            this.xMsBlobSequenceNumber = Long.parseLong(xMsBlobSequenceNumber);
        }
        if ((lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED)) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsEncryptionKeySha256 = rawHeaders.getValue(X_MS_ENCRYPTION_KEY_SHA256);
        this.xMsRequestId = rawHeaders.getValue(X_MS_REQUEST_ID);
        String xMsRequestServerEncrypted = rawHeaders.getValue(X_MS_REQUEST_SERVER_ENCRYPTED);
        if (xMsRequestServerEncrypted != null) {
            this.xMsRequestServerEncrypted = Boolean.parseBoolean(xMsRequestServerEncrypted);
        }
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5)) != null) {
            this.contentMD5 = Base64.getDecoder().decode(contentMD5);
        }
        this.xMsEncryptionScope = rawHeaders.getValue(X_MS_ENCRYPTION_SCOPE);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PageBlobsUploadPagesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PageBlobsUploadPagesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone(this.xMsContentCrc64);
    }

    public PageBlobsUploadPagesHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone(xMsContentCrc64);
        return this;
    }

    public Long getXMsBlobSequenceNumber() {
        return this.xMsBlobSequenceNumber;
    }

    public PageBlobsUploadPagesHeaders setXMsBlobSequenceNumber(Long xMsBlobSequenceNumber) {
        this.xMsBlobSequenceNumber = xMsBlobSequenceNumber;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PageBlobsUploadPagesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public PageBlobsUploadPagesHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PageBlobsUploadPagesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public PageBlobsUploadPagesHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public PageBlobsUploadPagesHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PageBlobsUploadPagesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone(this.contentMD5);
    }

    public PageBlobsUploadPagesHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone(contentMD5);
        return this;
    }

    public String getXMsEncryptionScope() {
        return this.xMsEncryptionScope;
    }

    public PageBlobsUploadPagesHeaders setXMsEncryptionScope(String xMsEncryptionScope) {
        this.xMsEncryptionScope = xMsEncryptionScope;
        return this;
    }
}

