/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.UrlBuilder;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RequestRetryPolicy
implements HttpPipelinePolicy {
    private final RequestRetryOptions requestRetryOptions;

    public RequestRetryPolicy(RequestRetryOptions requestRetryOptions) {
        this.requestRetryOptions = requestRetryOptions;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        boolean considerSecondary = this.requestRetryOptions.getSecondaryHost() != null && (HttpMethod.GET.equals((Object)context.getHttpRequest().getHttpMethod()) || HttpMethod.HEAD.equals((Object)context.getHttpRequest().getHttpMethod()));
        return this.attemptAsync(context, next, context.getHttpRequest(), considerSecondary, 1, 1, null);
    }

    private Mono<HttpResponse> attemptAsync(HttpPipelineCallContext context, HttpPipelineNextPolicy next, HttpRequest originalRequest, boolean considerSecondary, int primaryTry, int attempt, List<Throwable> suppressed) {
        boolean tryingPrimary = !considerSecondary || attempt % 2 != 0;
        long delayMs = tryingPrimary ? this.requestRetryOptions.calculateDelayInMs(primaryTry) : (long)(((double)(ThreadLocalRandom.current().nextFloat() / 2.0f) + 0.8) * 1000.0);
        context.setHttpRequest(originalRequest.copy());
        BinaryData originalRequestBody = originalRequest.getBodyAsBinaryData();
        if (originalRequestBody != null && !originalRequestBody.isReplayable()) {
            Flux<ByteBuffer> bufferedBody = context.getHttpRequest().getBody().map(ByteBuffer::duplicate);
            context.getHttpRequest().setBody(bufferedBody);
        }
        if (!tryingPrimary) {
            UrlBuilder builder = UrlBuilder.parse(context.getHttpRequest().getUrl());
            builder.setHost(this.requestRetryOptions.getSecondaryHost());
            try {
                context.getHttpRequest().setUrl(builder.toUrl());
            }
            catch (MalformedURLException e) {
                return Mono.error(e);
            }
        }
        context.setData("requestRetryCount", attempt);
        ProgressReporter progressReporter = Contexts.with(context.getContext()).getHttpRequestProgressReporter();
        if (progressReporter != null) {
            progressReporter.reset();
        }
        Mono<HttpResponse> responseMono = next.clone().process();
        if (this.requestRetryOptions.getTryTimeoutDuration().getSeconds() != Integer.MAX_VALUE) {
            responseMono = responseMono.timeout(this.requestRetryOptions.getTryTimeoutDuration());
        }
        if (delayMs > 0L) {
            responseMono = responseMono.delaySubscription(Duration.ofMillis(delayMs));
        }
        return responseMono.flatMap(response -> {
            boolean newConsiderSecondary = considerSecondary;
            boolean retry = false;
            int statusCode = response.getStatusCode();
            if (!tryingPrimary && statusCode == 404) {
                newConsiderSecondary = false;
                retry = true;
            } else if (statusCode == 503 || statusCode == 500) {
                retry = true;
            }
            if (retry && attempt < this.requestRetryOptions.getMaxTries()) {
                int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                Flux<ByteBuffer> responseBody = response.getBody();
                if (responseBody == null) {
                    return this.attemptAsync(context, next, originalRequest, newConsiderSecondary, newPrimaryTry, attempt + 1, suppressed);
                }
                return responseBody.ignoreElements().then(this.attemptAsync(context, next, originalRequest, newConsiderSecondary, newPrimaryTry, attempt + 1, suppressed));
            }
            return Mono.just(response);
        }).onErrorResume(throwable -> {
            if (throwable instanceof IllegalStateException && attempt > 1) {
                return Mono.error(new IllegalStateException("The request failed because the size of the contents of the provided Flux did not match the provided data size upon attempting to retry. This is likely caused by the Flux not being replayable. To support retries, all Fluxes must produce the same data for each subscriber. Please ensure this behavior.", (Throwable)throwable));
            }
            boolean retry = false;
            Throwable unwrappedThrowable = Exceptions.unwrap(throwable);
            if (unwrappedThrowable instanceof IOException) {
                retry = true;
            } else if (unwrappedThrowable instanceof TimeoutException) {
                retry = true;
            }
            if (retry && attempt < this.requestRetryOptions.getMaxTries()) {
                int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                List suppressedLocal = suppressed == null ? new LinkedList() : suppressed;
                suppressedLocal.add(unwrappedThrowable);
                return this.attemptAsync(context, next, originalRequest, considerSecondary, newPrimaryTry, attempt + 1, suppressedLocal);
            }
            if (suppressed != null) {
                suppressed.forEach(throwable::addSuppressed);
            }
            return Mono.error(throwable);
        });
    }
}

