/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.BlobDownloadResponse;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryResponse;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.FluxInputStream;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClient;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.models.InternalDataLakeFileOpenInputStreamResult;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeFileOpenInputStreamResult;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DownloadRetryOptions;
import com.azure.storage.file.datalake.models.FileQueryAsyncResponse;
import com.azure.storage.file.datalake.models.FileQueryHeaders;
import com.azure.storage.file.datalake.models.FileQueryResponse;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.models.FileReadResponse;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.options.DataLakeFileAppendOptions;
import com.azure.storage.file.datalake.options.DataLakeFileInputStreamOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import com.azure.storage.file.datalake.options.FileParallelUploadOptions;
import com.azure.storage.file.datalake.options.FileQueryOptions;
import com.azure.storage.file.datalake.options.FileScheduleDeletionOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@ServiceClient(builder=DataLakePathClientBuilder.class)
public class DataLakeFileClient
extends DataLakePathClient {
    private static final long MAX_APPEND_FILE_BYTES = 0xFA000000L;
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeFileClient.class);
    private final DataLakeFileAsyncClient dataLakeFileAsyncClient;

    DataLakeFileClient(DataLakeFileAsyncClient pathAsyncClient, BlockBlobClient blockBlobClient) {
        super(pathAsyncClient, blockBlobClient);
        this.dataLakeFileAsyncClient = pathAsyncClient;
    }

    private DataLakeFileClient(DataLakePathClient dataLakePathClient) {
        super(dataLakePathClient.dataLakePathAsyncClient, dataLakePathClient.blockBlobClient);
        this.dataLakeFileAsyncClient = new DataLakeFileAsyncClient(dataLakePathClient.dataLakePathAsyncClient);
    }

    public String getFileUrl() {
        return this.getPathUrl();
    }

    public String getFilePath() {
        return this.getObjectPath();
    }

    public String getFileName() {
        return this.getObjectName();
    }

    @Override
    public DataLakeFileClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        return new DataLakeFileClient(this.dataLakeFileAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.blockBlobClient.getCustomerProvidedKeyClient(Transforms.toBlobCustomerProvidedKey(customerProvidedKey)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.dataLakePathAsyncClient.deleteWithResponse(null, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.dataLakeFileAsyncClient.deleteIfExistsWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(InputStream data, long length) {
        return this.upload(data, length, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(BinaryData data) {
        return this.upload(data, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(InputStream data, long length, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.uploadWithResponse(new FileParallelUploadOptions(data, length).setRequestConditions(requestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(BinaryData data, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.uploadWithResponse(new FileParallelUploadOptions(data).setRequestConditions(requestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> uploadWithResponse(FileParallelUploadOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(options);
        Mono<Response<PathInfo>> upload = this.dataLakeFileAsyncClient.uploadWithResponse(options).contextWrite(FluxUtil.toReactorContext(context));
        try {
            return StorageImplUtils.blockWithOptionalTimeout(upload, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath) {
        this.uploadFromFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, boolean overwrite) {
        DataLakeRequestConditions requestConditions = null;
        if (!overwrite) {
            if (UploadUtils.shouldUploadInChunks(filePath, 0x6400000L, LOGGER) && this.exists().booleanValue()) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        this.uploadFromFile(filePath, null, null, null, requestConditions, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout) {
        Mono<Void> upload = this.dataLakeFileAsyncClient.uploadFromFile(filePath, parallelTransferOptions, headers, metadata, requestConditions);
        try {
            StorageImplUtils.blockWithOptionalTimeout(upload, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> uploadFromFileWithResponse(String filePath, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<PathInfo>> upload = this.dataLakeFileAsyncClient.uploadFromFileWithResponse(filePath, parallelTransferOptions, headers, metadata, requestConditions).contextWrite(FluxUtil.toReactorContext(context));
        try {
            return StorageImplUtils.blockWithOptionalTimeout(upload, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(InputStream data, long fileOffset, long length) {
        this.appendWithResponse(data, fileOffset, length, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(BinaryData data, long fileOffset) {
        this.appendWithResponse(data, fileOffset, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(InputStream data, long fileOffset, long length, byte[] contentMd5, String leaseId, Duration timeout, Context context) {
        DataLakeFileAppendOptions appendOptions = new DataLakeFileAppendOptions().setLeaseId(leaseId).setContentHash(contentMd5).setFlush(null);
        return this.appendWithResponse(data, fileOffset, length, appendOptions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(InputStream data, long fileOffset, long length, DataLakeFileAppendOptions appendOptions, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux<ByteBuffer> fbb = Utility.convertStreamToByteBuffer(data, length, 0x400000, true);
        Mono<Response<Void>> response = this.dataLakeFileAsyncClient.appendWithResponse(fbb.subscribeOn(Schedulers.elastic()), fileOffset, length, appendOptions, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(BinaryData data, long fileOffset, byte[] contentMd5, String leaseId, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux<ByteBuffer> fluxData = data.toFluxByteBuffer();
        DataLakeFileAppendOptions appendOptions = new DataLakeFileAppendOptions().setLeaseId(leaseId).setContentHash(contentMd5).setFlush(null);
        Mono<Response<Void>> response = this.dataLakeFileAsyncClient.appendWithResponse(fluxData.subscribeOn(Schedulers.boundedElastic()), fileOffset, (long)data.getLength(), appendOptions, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(BinaryData data, long fileOffset, DataLakeFileAppendOptions appendOptions, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux<ByteBuffer> fluxData = data.toFluxByteBuffer();
        Mono<Response<Void>> response = this.dataLakeFileAsyncClient.appendWithResponse(fluxData.subscribeOn(Schedulers.boundedElastic()), fileOffset, (long)data.getLength(), appendOptions, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo flush(long position) {
        return this.flush(position, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo flush(long position, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        return this.flushWithResponse(position, false, false, null, requestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> flushWithResponse(long position, boolean retainUncommittedData, boolean close, PathHttpHeaders httpHeaders, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<PathInfo>> response = this.dataLakeFileAsyncClient.flushWithResponse(position, retainUncommittedData, close, httpHeaders, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    public void read(OutputStream stream) {
        this.readWithResponse(stream, null, null, null, false, null, Context.NONE);
    }

    public FileReadResponse readWithResponse(OutputStream stream, FileRange range, DownloadRetryOptions options, DataLakeRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            BlobDownloadResponse response = this.blockBlobClient.downloadWithResponse(stream, Transforms.toBlobRange(range), Transforms.toBlobDownloadRetryOptions(options), Transforms.toBlobRequestConditions(requestConditions), getRangeContentMd5, timeout, context);
            return Transforms.toFileReadResponse(response);
        }, LOGGER);
    }

    public DataLakeFileOpenInputStreamResult openInputStream() {
        return this.openInputStream(null);
    }

    public DataLakeFileOpenInputStreamResult openInputStream(DataLakeFileInputStreamOptions options) {
        BlobInputStreamOptions convertedOptions = Transforms.toBlobInputStreamOptions(options);
        BlobInputStream inputStream = this.blockBlobClient.openInputStream(convertedOptions);
        return new InternalDataLakeFileOpenInputStreamResult(inputStream, Transforms.toPathProperties(inputStream.getProperties()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathProperties readToFile(String filePath) {
        return this.readToFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathProperties readToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return this.readToFileWithResponse(filePath, null, null, null, null, false, openOptions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathProperties> readToFileWithResponse(String filePath, FileRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, DataLakeRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobProperties> response = this.blockBlobClient.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(Transforms.toBlobRange(range)).setParallelTransferOptions(parallelTransferOptions).setDownloadRetryOptions(Transforms.toBlobDownloadRetryOptions(downloadRetryOptions)).setRequestConditions(Transforms.toBlobRequestConditions(requestConditions)).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions), timeout, context);
            return new SimpleResponse<PathProperties>(response, Transforms.toPathProperties(response.getValue()));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient rename(String destinationFileSystem, String destinationPath) {
        return this.renameWithResponse(destinationFileSystem, destinationPath, null, null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Duration timeout, Context context) {
        Mono<Response> response = this.dataLakeFileAsyncClient.renameWithResponse(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, context).map(asyncResponse -> new SimpleResponse<DataLakeFileClient>(asyncResponse.getRequest(), asyncResponse.getStatusCode(), asyncResponse.getHeaders(), new DataLakeFileClient(new DataLakeFileAsyncClient((DataLakePathAsyncClient)asyncResponse.getValue()), new SpecializedBlobClientBuilder().blobAsyncClient(((DataLakePathAsyncClient)asyncResponse.getValue()).blockBlobAsyncClient).buildBlockBlobClient())));
        Response resp = StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        return new SimpleResponse<DataLakeFileClient>(resp, new DataLakeFileClient((DataLakePathClient)resp.getValue()));
    }

    public InputStream openQueryInputStream(String expression) {
        return this.openQueryInputStreamWithResponse(new FileQueryOptions(expression)).getValue();
    }

    public Response<InputStream> openQueryInputStreamWithResponse(FileQueryOptions queryOptions) {
        FileQueryAsyncResponse response = this.dataLakeFileAsyncClient.queryWithResponse(queryOptions).block();
        if (response == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Query response cannot be null"));
        }
        return new ResponseBase<FileQueryHeaders, FluxInputStream>(response.getRequest(), response.getStatusCode(), response.getHeaders(), new FluxInputStream((Flux)response.getValue()), (FileQueryHeaders)response.getDeserializedHeaders());
    }

    public void query(OutputStream stream, String expression) {
        this.queryWithResponse(new FileQueryOptions(expression, stream), null, Context.NONE);
    }

    public FileQueryResponse queryWithResponse(FileQueryOptions queryOptions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            BlobQueryResponse response = this.blockBlobClient.queryWithResponse(Transforms.toBlobQueryOptions(queryOptions), timeout, context);
            return Transforms.toFileQueryResponse(response);
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void scheduleDeletion(FileScheduleDeletionOptions options) {
        this.scheduleDeletionWithResponse(options, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> scheduleDeletionWithResponse(FileScheduleDeletionOptions options, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.dataLakeFileAsyncClient.scheduleDeletionWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }
}

