/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.models.FileSystemsCreateHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsDeleteHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListBlobHierarchySegmentHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsSetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.ListBlobsHierarchySegmentResponse;
import com.azure.storage.file.datalake.implementation.models.ListBlobsIncludeItem;
import com.azure.storage.file.datalake.implementation.models.ListBlobsShowOnly;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathList;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class FileSystemsImpl {
    private final FileSystemsService service;
    private final AzureDataLakeStorageRestAPIImpl client;

    FileSystemsImpl(AzureDataLakeStorageRestAPIImpl client) {
        this.service = RestProxy.create(FileSystemsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsCreateHeaders, Void>> createWithResponseAsync(String requestId, Integer timeout, String properties) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsCreateHeaders, Void>> createWithResponseAsync(String requestId, Integer timeout, String properties, Context context) {
        String accept = "application/json";
        return this.service.create(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String requestId, Integer timeout, String properties) {
        return this.createWithResponseAsync(requestId, timeout, properties).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String requestId, Integer timeout, String properties, Context context) {
        return this.createWithResponseAsync(requestId, timeout, properties, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.setProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions) {
        return this.setPropertiesWithResponseAsync(requestId, timeout, properties, modifiedAccessConditions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.setPropertiesWithResponseAsync(requestId, timeout, properties, modifiedAccessConditions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String requestId, Integer timeout) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String requestId, Integer timeout, Context context) {
        String accept = "application/json";
        return this.service.getProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String requestId, Integer timeout) {
        return this.getPropertiesWithResponseAsync(requestId, timeout).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String requestId, Integer timeout, Context context) {
        return this.getPropertiesWithResponseAsync(requestId, timeout, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsDeleteHeaders, Void>> deleteWithResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsDeleteHeaders, Void>> deleteWithResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions) {
        return this.deleteWithResponseAsync(requestId, timeout, modifiedAccessConditions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.deleteWithResponseAsync(requestId, timeout, modifiedAccessConditions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListPathsHeaders, PathList>> listPathsWithResponseAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPaths(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListPathsHeaders, PathList>> listPathsWithResponseAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        String accept = "application/json";
        return this.service.listPaths(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathList> listPathsAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn) {
        return this.listPathsWithResponseAsync(recursive, requestId, timeout, continuation, path, maxResults, upn).flatMap(res -> Mono.justOrEmpty((PathList)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathList> listPathsAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        return this.listPathsWithResponseAsync(recursive, requestId, timeout, continuation, path, maxResults, upn, context).flatMap(res -> Mono.justOrEmpty((PathList)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentWithResponseAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobHierarchySegment(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentWithResponseAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listBlobHierarchySegment(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId) {
        return this.listBlobHierarchySegmentWithResponseAsync(prefix, delimiter, marker, maxResults, include, showonly, timeout, requestId).flatMap(res -> Mono.justOrEmpty((ListBlobsHierarchySegmentResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId, Context context) {
        return this.listBlobHierarchySegmentWithResponseAsync(prefix, delimiter, marker, maxResults, include, showonly, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((ListBlobsHierarchySegmentResponse)res.getValue()));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureDataLakeStorage")
    public static interface FileSystemsService {
        @Put(value="/{filesystem}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<FileSystemsCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Patch(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<FileSystemsSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Head(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<FileSystemsGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/{filesystem}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<FileSystemsDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<FileSystemsListPathsHeaders, PathList>> listPaths(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="continuation") String var7, @QueryParam(value="directory") String var8, @QueryParam(value="recursive") boolean var9, @QueryParam(value="maxResults") Integer var10, @QueryParam(value="upn") Boolean var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegment(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxResults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="showonly") ListBlobsShowOnly var10, @QueryParam(value="timeout") Integer var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="Accept") String var14, Context var15);
    }
}

