/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.util;

import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.TimeAndFormat;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import com.azure.storage.file.datalake.sas.FileSystemSasPermission;
import com.azure.storage.file.datalake.sas.PathSasPermission;
import java.time.OffsetDateTime;
import java.util.Objects;

public class DataLakeSasImplUtil {
    private static final String SAS_BLOB_CONSTANT = "b";
    private static final String SAS_DIRECTORY_CONSTANT = "d";
    private static final String SAS_CONTAINER_CONSTANT = "c";
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeSasImplUtil.class);
    private static final String VERSION = Configuration.getGlobalConfiguration().get("AZURE_STORAGE_SAS_SERVICE_VERSION", DataLakeServiceVersion.getLatest().getVersion());
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String fileSystemName;
    private String pathName;
    private String resource;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private Boolean isDirectory;
    private Integer directoryDepth;
    private String authorizedAadObjectId;
    private String unauthorizedAadObjectId;
    private String correlationId;
    private String encryptionScope;

    public DataLakeSasImplUtil(DataLakeServiceSasSignatureValues sasValues, String fileSystemName) {
        this(sasValues, fileSystemName, null, false);
    }

    public DataLakeSasImplUtil(DataLakeServiceSasSignatureValues sasValues, String fileSystemName, String pathName, boolean isDirectory) {
        Objects.requireNonNull(sasValues);
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.fileSystemName = fileSystemName;
        this.pathName = pathName;
        this.identifier = sasValues.getIdentifier();
        this.cacheControl = sasValues.getCacheControl();
        this.contentDisposition = sasValues.getContentDisposition();
        this.contentEncoding = sasValues.getContentEncoding();
        this.contentLanguage = sasValues.getContentLanguage();
        this.contentType = sasValues.getContentType();
        this.authorizedAadObjectId = sasValues.getPreauthorizedAgentObjectId();
        this.unauthorizedAadObjectId = sasValues.getAgentObjectId();
        this.correlationId = sasValues.getCorrelationId();
        this.isDirectory = isDirectory;
        this.encryptionScope = sasValues.getEncryptionScope();
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Context context) {
        StorageImplUtils.assertNotNull("storageSharedKeyCredentials", storageSharedKeyCredentials);
        this.ensureState();
        String canonicalName = this.getCanonicalName(storageSharedKeyCredentials.getAccountName());
        String stringToSign = this.stringToSign(canonicalName);
        StorageImplUtils.logStringToSign(LOGGER, stringToSign, context);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        return this.encode(null, signature);
    }

    public String generateUserDelegationSas(UserDelegationKey delegationKey, String accountName, Context context) {
        StorageImplUtils.assertNotNull("delegationKey", delegationKey);
        StorageImplUtils.assertNotNull("accountName", accountName);
        this.ensureState();
        String canonicalName = this.getCanonicalName(accountName);
        String stringToSign = this.stringToSign(delegationKey, canonicalName);
        StorageImplUtils.logStringToSign(LOGGER, stringToSign, context);
        String signature = StorageImplUtils.computeHMac256(delegationKey.getValue(), stringToSign);
        return this.encode(delegationKey, signature);
    }

    private String encode(UserDelegationKey userDelegationKey, String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter(sb, "sv", VERSION);
        SasImplUtils.tryAppendQueryParameter(sb, "spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter(sb, "st", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(this.startTime, null)));
        SasImplUtils.tryAppendQueryParameter(sb, "se", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(this.expiryTime, null)));
        SasImplUtils.tryAppendQueryParameter(sb, "sip", this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter(sb, "si", this.identifier);
        if (userDelegationKey != null) {
            SasImplUtils.tryAppendQueryParameter(sb, "skoid", userDelegationKey.getSignedObjectId());
            SasImplUtils.tryAppendQueryParameter(sb, "sktid", userDelegationKey.getSignedTenantId());
            SasImplUtils.tryAppendQueryParameter(sb, "skt", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(userDelegationKey.getSignedStart(), null)));
            SasImplUtils.tryAppendQueryParameter(sb, "ske", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(userDelegationKey.getSignedExpiry(), null)));
            SasImplUtils.tryAppendQueryParameter(sb, "sks", userDelegationKey.getSignedService());
            SasImplUtils.tryAppendQueryParameter(sb, "skv", userDelegationKey.getSignedVersion());
            SasImplUtils.tryAppendQueryParameter(sb, "saoid", this.authorizedAadObjectId);
            SasImplUtils.tryAppendQueryParameter(sb, "suoid", this.unauthorizedAadObjectId);
            SasImplUtils.tryAppendQueryParameter(sb, "scid", this.correlationId);
        }
        SasImplUtils.tryAppendQueryParameter(sb, "sr", this.resource);
        SasImplUtils.tryAppendQueryParameter(sb, "sp", this.permissions);
        if (this.isDirectory.booleanValue()) {
            SasImplUtils.tryAppendQueryParameter(sb, "sdd", this.directoryDepth);
        }
        SasImplUtils.tryAppendQueryParameter(sb, "sig", signature);
        SasImplUtils.tryAppendQueryParameter(sb, "rscc", this.cacheControl);
        SasImplUtils.tryAppendQueryParameter(sb, "rscd", this.contentDisposition);
        SasImplUtils.tryAppendQueryParameter(sb, "rsce", this.contentEncoding);
        SasImplUtils.tryAppendQueryParameter(sb, "rscl", this.contentLanguage);
        SasImplUtils.tryAppendQueryParameter(sb, "rsct", this.contentType);
        SasImplUtils.tryAppendQueryParameter(sb, "ses", this.encryptionScope);
        return sb.toString();
    }

    private void ensureState() {
        if (this.identifier == null && (this.expiryTime == null || this.permissions == null)) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("If identifier is not set, expiry time and permissions must be set"));
        }
        if (CoreUtils.isNullOrEmpty(this.pathName)) {
            this.resource = SAS_CONTAINER_CONSTANT;
        } else if (this.isDirectory.booleanValue()) {
            this.resource = SAS_DIRECTORY_CONSTANT;
            this.directoryDepth = this.pathName.split("/").length;
        } else {
            this.resource = SAS_BLOB_CONSTANT;
        }
        if (this.permissions != null) {
            switch (this.resource) {
                case "b": 
                case "d": {
                    this.permissions = PathSasPermission.parse(this.permissions).toString();
                    break;
                }
                case "c": {
                    this.permissions = FileSystemSasPermission.parse(this.permissions).toString();
                    break;
                }
                default: {
                    LOGGER.info("Not re-parsing permissions. Resource type '{}' is unknown.", this.resource);
                }
            }
        }
        if (this.authorizedAadObjectId != null && this.unauthorizedAadObjectId != null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("agentObjectId and preauthorizedAgentObjectId can not both be set."));
        }
    }

    private String getCanonicalName(String account) {
        return CoreUtils.isNullOrEmpty(this.pathName) ? String.format("/blob/%s/%s", account, this.fileSystemName) : String.format("/blob/%s/%s/%s", account, this.fileSystemName, this.pathName.replace("\\", "/"));
    }

    private String stringToSign(String canonicalName) {
        if (VERSION.compareTo(DataLakeServiceVersion.V2020_10_02.getVersion()) <= 0) {
            return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION, this.resource, "", this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
        }
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION, this.resource, "", this.encryptionScope == null ? "" : this.encryptionScope, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }

    private String stringToSign(UserDelegationKey key, String canonicalName) {
        if (VERSION.compareTo(DataLakeServiceVersion.V2019_12_12.getVersion()) <= 0) {
            return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, key.getSignedObjectId() == null ? "" : key.getSignedObjectId(), key.getSignedTenantId() == null ? "" : key.getSignedTenantId(), key.getSignedStart() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedStart()), key.getSignedExpiry() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedExpiry()), key.getSignedService() == null ? "" : key.getSignedService(), key.getSignedVersion() == null ? "" : key.getSignedVersion(), this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION, this.resource, "", this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
        }
        if (VERSION.compareTo(DataLakeServiceVersion.V2020_10_02.getVersion()) <= 0) {
            return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, key.getSignedObjectId() == null ? "" : key.getSignedObjectId(), key.getSignedTenantId() == null ? "" : key.getSignedTenantId(), key.getSignedStart() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedStart()), key.getSignedExpiry() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedExpiry()), key.getSignedService() == null ? "" : key.getSignedService(), key.getSignedVersion() == null ? "" : key.getSignedVersion(), this.authorizedAadObjectId == null ? "" : this.authorizedAadObjectId, this.unauthorizedAadObjectId == null ? "" : this.unauthorizedAadObjectId, this.correlationId == null ? "" : this.correlationId, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION, this.resource, "", this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
        }
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, key.getSignedObjectId() == null ? "" : key.getSignedObjectId(), key.getSignedTenantId() == null ? "" : key.getSignedTenantId(), key.getSignedStart() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedStart()), key.getSignedExpiry() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedExpiry()), key.getSignedService() == null ? "" : key.getSignedService(), key.getSignedVersion() == null ? "" : key.getSignedVersion(), this.authorizedAadObjectId == null ? "" : this.authorizedAadObjectId, this.unauthorizedAadObjectId == null ? "" : this.unauthorizedAadObjectId, this.correlationId == null ? "" : this.correlationId, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION, this.resource, "", this.encryptionScope == null ? "" : this.encryptionScope, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

