/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.options;

import com.azure.core.util.BinaryData;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;

public class FileParallelUploadOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final BinaryData data;
    private final Long length;
    private ParallelTransferOptions parallelTransferOptions;
    private PathHttpHeaders headers;
    private Map<String, String> metadata;
    private String permissions;
    private String umask;
    private DataLakeRequestConditions requestConditions;

    public FileParallelUploadOptions(Flux<ByteBuffer> dataFlux) {
        StorageImplUtils.assertNotNull("dataFlux", dataFlux);
        this.dataFlux = dataFlux;
        this.dataStream = null;
        this.length = null;
        this.data = null;
    }

    public FileParallelUploadOptions(BinaryData data) {
        StorageImplUtils.assertNotNull("data must not be null", data);
        this.data = data;
        this.length = data.getLength();
        this.dataFlux = null;
        this.dataStream = null;
    }

    @Deprecated
    public FileParallelUploadOptions(InputStream dataStream, long length) {
        this(dataStream, (Long)length);
    }

    public FileParallelUploadOptions(InputStream dataStream) {
        this(dataStream, null);
    }

    private FileParallelUploadOptions(InputStream dataStream, Long length) {
        StorageImplUtils.assertNotNull("dataStream", dataStream);
        if (length != null) {
            StorageImplUtils.assertInBounds("length", length, 0L, Long.MAX_VALUE);
        }
        this.dataStream = dataStream;
        this.length = length;
        this.dataFlux = null;
        this.data = null;
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public BinaryData getData() {
        return this.data;
    }

    @Deprecated
    public long getLength() {
        return this.length;
    }

    public Long getOptionalLength() {
        return this.length;
    }

    public ParallelTransferOptions getParallelTransferOptions() {
        return this.parallelTransferOptions;
    }

    public FileParallelUploadOptions setParallelTransferOptions(ParallelTransferOptions parallelTransferOptions) {
        this.parallelTransferOptions = parallelTransferOptions;
        return this;
    }

    public PathHttpHeaders getHeaders() {
        return this.headers;
    }

    public FileParallelUploadOptions setHeaders(PathHttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public FileParallelUploadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public FileParallelUploadOptions setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public String getUmask() {
        return this.umask;
    }

    public FileParallelUploadOptions setUmask(String umask) {
        this.umask = umask;
        return this;
    }

    public DataLakeRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public FileParallelUploadOptions setRequestConditions(DataLakeRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }
}

