/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import com.azure.core.credential.AzureSasCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.storage.datalake.DataLakeComponent;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DataLakeComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private DataLakeConfiguration getOrCreateConfiguration(DataLakeComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new DataLakeConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DataLakeComponent target = (DataLakeComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accountkey": 
            case "accountKey": {
                this.getOrCreateConfiguration(target).setAccountKey(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(DataLakeComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(DataLakeComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clientsecret": 
            case "clientSecret": {
                this.getOrCreateConfiguration(target).setClientSecret(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clientsecretcredential": 
            case "clientSecretCredential": {
                this.getOrCreateConfiguration(target).setClientSecretCredential(DataLakeComponentConfigurer.property(camelContext, ClientSecretCredential.class, value));
                return true;
            }
            case "close": {
                this.getOrCreateConfiguration(target).setClose(DataLakeComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                this.getOrCreateConfiguration(target).setCloseStreamAfterRead(DataLakeComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(DataLakeComponentConfigurer.property(camelContext, DataLakeConfiguration.class, value));
                return true;
            }
            case "datacount": 
            case "dataCount": {
                this.getOrCreateConfiguration(target).setDataCount(DataLakeComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "directoryname": 
            case "directoryName": {
                this.getOrCreateConfiguration(target).setDirectoryName(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                this.getOrCreateConfiguration(target).setDownloadLinkExpiration(DataLakeComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "expression": {
                this.getOrCreateConfiguration(target).setExpression(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "filedir": 
            case "fileDir": {
                this.getOrCreateConfiguration(target).setFileDir(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "filename": 
            case "fileName": {
                this.getOrCreateConfiguration(target).setFileName(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "fileoffset": 
            case "fileOffset": {
                this.getOrCreateConfiguration(target).setFileOffset(DataLakeComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(DataLakeComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxresults": 
            case "maxResults": {
                this.getOrCreateConfiguration(target).setMaxResults(DataLakeComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                this.getOrCreateConfiguration(target).setMaxRetryRequests(DataLakeComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "openoptions": 
            case "openOptions": {
                this.getOrCreateConfiguration(target).setOpenOptions(DataLakeComponentConfigurer.property(camelContext, Set.class, value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation(DataLakeComponentConfigurer.property(camelContext, DataLakeOperationsDefinition.class, value));
                return true;
            }
            case "path": {
                this.getOrCreateConfiguration(target).setPath(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "permission": {
                this.getOrCreateConfiguration(target).setPermission(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "position": {
                this.getOrCreateConfiguration(target).setPosition(DataLakeComponentConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "recursive": {
                this.getOrCreateConfiguration(target).setRecursive(DataLakeComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "regex": {
                this.getOrCreateConfiguration(target).setRegex(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "retainuncommiteddata": 
            case "retainUncommitedData": {
                this.getOrCreateConfiguration(target).setRetainUncommitedData(DataLakeComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "sascredential": 
            case "sasCredential": {
                this.getOrCreateConfiguration(target).setSasCredential(DataLakeComponentConfigurer.property(camelContext, AzureSasCredential.class, value));
                return true;
            }
            case "sassignature": 
            case "sasSignature": {
                this.getOrCreateConfiguration(target).setSasSignature(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "serviceclient": 
            case "serviceClient": {
                this.getOrCreateConfiguration(target).setServiceClient(DataLakeComponentConfigurer.property(camelContext, DataLakeServiceClient.class, value));
                return true;
            }
            case "sharedkeycredential": 
            case "sharedKeyCredential": {
                this.getOrCreateConfiguration(target).setSharedKeyCredential(DataLakeComponentConfigurer.property(camelContext, StorageSharedKeyCredential.class, value));
                return true;
            }
            case "tenantid": 
            case "tenantId": {
                this.getOrCreateConfiguration(target).setTenantId(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "timeout": {
                this.getOrCreateConfiguration(target).setTimeout(DataLakeComponentConfigurer.property(camelContext, Duration.class, value));
                return true;
            }
            case "umask": {
                this.getOrCreateConfiguration(target).setUmask(DataLakeComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "usedefaultidentity": 
            case "useDefaultIdentity": {
                this.getOrCreateConfiguration(target).setUseDefaultIdentity(DataLakeComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "userprincipalnamereturned": 
            case "userPrincipalNameReturned": {
                this.getOrCreateConfiguration(target).setUserPrincipalNameReturned(DataLakeComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"serviceClient"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accountkey": 
            case "accountKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "clientsecret": 
            case "clientSecret": {
                return String.class;
            }
            case "clientsecretcredential": 
            case "clientSecretCredential": {
                return ClientSecretCredential.class;
            }
            case "close": {
                return Boolean.class;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return Boolean.class;
            }
            case "configuration": {
                return DataLakeConfiguration.class;
            }
            case "datacount": 
            case "dataCount": {
                return Long.class;
            }
            case "directoryname": 
            case "directoryName": {
                return String.class;
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                return Long.class;
            }
            case "expression": {
                return String.class;
            }
            case "filedir": 
            case "fileDir": {
                return String.class;
            }
            case "filename": 
            case "fileName": {
                return String.class;
            }
            case "fileoffset": 
            case "fileOffset": {
                return Long.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxresults": 
            case "maxResults": {
                return Integer.class;
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                return Integer.TYPE;
            }
            case "openoptions": 
            case "openOptions": {
                return Set.class;
            }
            case "operation": {
                return DataLakeOperationsDefinition.class;
            }
            case "path": {
                return String.class;
            }
            case "permission": {
                return String.class;
            }
            case "position": {
                return Long.class;
            }
            case "recursive": {
                return Boolean.class;
            }
            case "regex": {
                return String.class;
            }
            case "retainuncommiteddata": 
            case "retainUncommitedData": {
                return Boolean.class;
            }
            case "sascredential": 
            case "sasCredential": {
                return AzureSasCredential.class;
            }
            case "sassignature": 
            case "sasSignature": {
                return String.class;
            }
            case "serviceclient": 
            case "serviceClient": {
                return DataLakeServiceClient.class;
            }
            case "sharedkeycredential": 
            case "sharedKeyCredential": {
                return StorageSharedKeyCredential.class;
            }
            case "tenantid": 
            case "tenantId": {
                return String.class;
            }
            case "timeout": {
                return Duration.class;
            }
            case "umask": {
                return String.class;
            }
            case "usedefaultidentity": 
            case "useDefaultIdentity": {
                return Boolean.class;
            }
            case "userprincipalnamereturned": 
            case "userPrincipalNameReturned": {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DataLakeComponent target = (DataLakeComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accountkey": 
            case "accountKey": {
                return this.getOrCreateConfiguration(target).getAccountKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "clientsecret": 
            case "clientSecret": {
                return this.getOrCreateConfiguration(target).getClientSecret();
            }
            case "clientsecretcredential": 
            case "clientSecretCredential": {
                return this.getOrCreateConfiguration(target).getClientSecretCredential();
            }
            case "close": {
                return this.getOrCreateConfiguration(target).getClose();
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return this.getOrCreateConfiguration(target).getCloseStreamAfterRead();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "datacount": 
            case "dataCount": {
                return this.getOrCreateConfiguration(target).getDataCount();
            }
            case "directoryname": 
            case "directoryName": {
                return this.getOrCreateConfiguration(target).getDirectoryName();
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                return this.getOrCreateConfiguration(target).getDownloadLinkExpiration();
            }
            case "expression": {
                return this.getOrCreateConfiguration(target).getExpression();
            }
            case "filedir": 
            case "fileDir": {
                return this.getOrCreateConfiguration(target).getFileDir();
            }
            case "filename": 
            case "fileName": {
                return this.getOrCreateConfiguration(target).getFileName();
            }
            case "fileoffset": 
            case "fileOffset": {
                return this.getOrCreateConfiguration(target).getFileOffset();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresults": 
            case "maxResults": {
                return this.getOrCreateConfiguration(target).getMaxResults();
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                return this.getOrCreateConfiguration(target).getMaxRetryRequests();
            }
            case "openoptions": 
            case "openOptions": {
                return this.getOrCreateConfiguration(target).getOpenOptions();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "path": {
                return this.getOrCreateConfiguration(target).getPath();
            }
            case "permission": {
                return this.getOrCreateConfiguration(target).getPermission();
            }
            case "position": {
                return this.getOrCreateConfiguration(target).getPosition();
            }
            case "recursive": {
                return this.getOrCreateConfiguration(target).getRecursive();
            }
            case "regex": {
                return this.getOrCreateConfiguration(target).getRegex();
            }
            case "retainuncommiteddata": 
            case "retainUncommitedData": {
                return this.getOrCreateConfiguration(target).getRetainUncommitedData();
            }
            case "sascredential": 
            case "sasCredential": {
                return this.getOrCreateConfiguration(target).getSasCredential();
            }
            case "sassignature": 
            case "sasSignature": {
                return this.getOrCreateConfiguration(target).getSasSignature();
            }
            case "serviceclient": 
            case "serviceClient": {
                return this.getOrCreateConfiguration(target).getServiceClient();
            }
            case "sharedkeycredential": 
            case "sharedKeyCredential": {
                return this.getOrCreateConfiguration(target).getSharedKeyCredential();
            }
            case "tenantid": 
            case "tenantId": {
                return this.getOrCreateConfiguration(target).getTenantId();
            }
            case "timeout": {
                return this.getOrCreateConfiguration(target).getTimeout();
            }
            case "umask": {
                return this.getOrCreateConfiguration(target).getUmask();
            }
            case "usedefaultidentity": 
            case "useDefaultIdentity": {
                return this.getOrCreateConfiguration(target).getUseDefaultIdentity();
            }
            case "userprincipalnamereturned": 
            case "userPrincipalNameReturned": {
                return this.getOrCreateConfiguration(target).getUserPrincipalNameReturned();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "openoptions": 
            case "openOptions": {
                return OpenOption.class;
            }
        }
        return null;
    }
}

