/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.AccessTier;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.FileQueryError;
import com.azure.storage.file.datalake.models.FileQueryProgress;
import com.azure.storage.file.datalake.models.FileQuerySerialization;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.options.FileQueryOptions;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeExchangeHeaders;
import org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLakeConfigurationOptionsProxy {
    private static final Logger LOG = LoggerFactory.getLogger(DataLakeConfigurationOptionsProxy.class);
    private final DataLakeConfiguration configuration;

    public DataLakeConfigurationOptionsProxy(DataLakeConfiguration configuration) {
        this.configuration = configuration;
    }

    public ListFileSystemsOptions getListFileSystemOptions(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getListFileSystemOptionsFromHeaders, () -> null, exchange);
    }

    public Duration getTimeout(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getTimoutFromHeaders, this.configuration::getTimeout, exchange);
    }

    public DataLakeOperationsDefinition getOperation(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getDataLakeOperationsDefinitionFromHeader, this.configuration::getOperation, exchange);
    }

    public String getFileSystemName(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getFileSystemNameFromHeaders, this.configuration::getFileSystemName, exchange);
    }

    public String getDirectoryName(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getDirectoryNameFromHeaders, this.configuration::getDirectoryName, exchange);
    }

    public String getFileName(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getFileNameFromHeaders, this.configuration::getFileName, exchange);
    }

    public ListPathsOptions getListPathsOptions(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getListPathsOptionsFromHeaders, () -> null, exchange);
    }

    public String getPath(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getPathFromHeaders, this.configuration::getPath, exchange);
    }

    public Boolean isRecursive(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getRecursiveFromHeaders, this.configuration::getRecursive, exchange);
    }

    public Integer getMaxResults(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getMaxResultsFromHeaders, this.configuration::getMaxResults, exchange);
    }

    public Boolean isUserPrincipalNameReturned(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getUserPrincipalNameReturnedFromHeaders, this.configuration::getUserPrincipalNameReturned, exchange);
    }

    public String getRegex(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getRegexFromHeaders, this.configuration::getRegex, exchange);
    }

    public String getFileDir(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getFileDirFromHeaders, this.configuration::getFileDir, exchange);
    }

    public Long getDownloadLinkExpiration(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getDownloadLinkExpirationFromHeaders, this.configuration::getDownloadLinkExpiration, exchange);
    }

    public Long getFileOffset(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getFileOffsetFromHeaders, this.configuration::getFileOffset, exchange);
    }

    public String getLeaseId(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getLeaseIdFromHeaders, () -> null, exchange);
    }

    public Boolean getFlush(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getFlushFromHeaders, () -> Boolean.FALSE, exchange);
    }

    public Boolean retainUnCommitedData(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getRetainUncommittedDataFromHeaders, this.configuration::getRetainUncommitedData, exchange);
    }

    public Boolean getClose(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getCloseFromHeaders, this.configuration::getClose, exchange);
    }

    public Long getPosition(Exchange exchange) {
        LOG.info("Position: {}", (Object)this.configuration.getPosition());
        return this.getOption(DataLakeExchangeHeaders::getPositionFromHeaders, this.configuration::getPosition, exchange);
    }

    public ListPathsOptions getListPathOptions(Exchange exchange) {
        ListPathsOptions pathsOptions = this.getListPathsOptions(exchange);
        if (ObjectHelper.isNotEmpty(pathsOptions)) {
            return pathsOptions;
        }
        pathsOptions = new ListPathsOptions();
        String path = this.getPath(exchange);
        Boolean recursive = this.isRecursive(exchange);
        Integer maxResults = this.getMaxResults(exchange);
        Boolean userPrincipalNameReturned = this.isUserPrincipalNameReturned(exchange);
        pathsOptions = pathsOptions.setPath(path).setMaxResults(maxResults).setRecursive(recursive).setUserPrincipalNameReturned(userPrincipalNameReturned);
        return pathsOptions;
    }

    public String getExpression(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getExpressionFromHeaders, this.configuration::getExpression, exchange);
    }

    public FileQuerySerialization getInputSerialization(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getInputSerializationFromHeaders, () -> null, exchange);
    }

    public FileQuerySerialization getOutputSerialization(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getOutputSerializationFromHeaders, () -> null, exchange);
    }

    public Consumer<FileQueryError> getErrorConsuer(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getErrorConsumerFromHeaders, () -> null, exchange);
    }

    public Consumer<FileQueryProgress> getProgressConsuer(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getProgressConsumerFromHeaders, () -> null, exchange);
    }

    public FileQueryOptions getFileQueryOption(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getQueryOptionsFromHeaders, () -> null, exchange);
    }

    public String getPermission(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getPermissionFromHeaders, this.configuration::getPermission, exchange);
    }

    public String getUmask(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getUmaskFromHeaders, this.configuration::getUmask, exchange);
    }

    public Set<OpenOption> getOpenOptions(Exchange exchange) {
        return this.getOption(DataLakeExchangeHeaders::getOpenOptionsFromHeaders, this.configuration::getOpenOptions, exchange);
    }

    public FileQueryOptions getFileQueryOptions(Exchange exchange) {
        FileQueryOptions queryOptions = this.getFileQueryOption(exchange);
        if (ObjectHelper.isNotEmpty(queryOptions)) {
            return queryOptions;
        }
        String expression = this.getExpression(exchange);
        FileQuerySerialization inputSerialization = this.getInputSerialization(exchange);
        FileQuerySerialization outputSerialization = this.getOutputSerialization(exchange);
        Consumer<FileQueryError> errorConsumer = this.getErrorConsuer(exchange);
        Consumer<FileQueryProgress> progressConsumer = this.getProgressConsuer(exchange);
        queryOptions = new FileQueryOptions(expression).setInputSerialization(inputSerialization).setOutputSerialization(outputSerialization).setErrorConsumer(errorConsumer).setProgressConsumer(progressConsumer);
        return queryOptions;
    }

    public Map<String, String> getMetadata(Exchange exchange) {
        return DataLakeExchangeHeaders.getMedataFromHeaders(exchange);
    }

    public PublicAccessType getPublicAccessType(Exchange exchange) {
        return DataLakeExchangeHeaders.getPublicAccessTypeFromHeaders(exchange);
    }

    public DataLakeRequestConditions getDataLakeRequestConditions(Exchange exchange) {
        return DataLakeExchangeHeaders.getDataLakeRequestConditionsFromHeaders(exchange);
    }

    public AccessTier getAccessTier(Exchange exchange) {
        return DataLakeExchangeHeaders.getAccessTierFromHeaders(exchange);
    }

    public byte[] getContentMd5(Exchange exchange) {
        return DataLakeExchangeHeaders.getContendMd5FromHeaders(exchange);
    }

    public ParallelTransferOptions getParallelTransferOptions(Exchange exchange) {
        return DataLakeExchangeHeaders.getParallelTransferOptionsFromHeaders(exchange);
    }

    public PathHttpHeaders getPathHttpHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getPathHttpHeadersFromHeaders(exchange);
    }

    public DataLakeFileClient getFileClient(Exchange exchange) {
        return DataLakeExchangeHeaders.getFileClientFromHeaders(exchange);
    }

    public int getMaxRetryRequests() {
        return this.configuration.getMaxRetryRequests();
    }

    public FileRange getFileRange(Exchange exchange) {
        FileRange fileRange = DataLakeExchangeHeaders.getFileRangeFromHeaders(exchange);
        Long fileOffset = this.configuration.getFileOffset();
        Long dataCount = this.configuration.getDataCount();
        if (fileRange != null) {
            return fileRange;
        }
        if (fileOffset != null && dataCount != null) {
            return new FileRange(this.configuration.getFileOffset(), this.configuration.getDataCount());
        }
        return null;
    }

    public DataLakeConfiguration getConfiguration() {
        return this.configuration;
    }

    private <R> R getOption(Function<Exchange, R> exchangeFn, Supplier<R> fallbackFn, Exchange exchange) {
        if (ObjectHelper.isEmpty(exchange) || ObjectHelper.isEmpty(exchangeFn.apply(exchange))) {
            return fallbackFn.get();
        }
        return exchangeFn.apply(exchange);
    }
}

