/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.IOUtils;

public final class DataLakeUtils {
    private DataLakeUtils() {
    }

    public static Message getInMessage(Exchange exchange) {
        if (ObjectHelper.isEmpty(exchange)) {
            return null;
        }
        return exchange.getIn();
    }

    public static Long getInputStreamLength(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Inputstream with mark reset support required");
        }
        long length = IOUtils.toByteArray((InputStream)inputStream).length;
        inputStream.reset();
        return length;
    }
}

