/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.client;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeFileClientWrapper;
import org.apache.camel.util.ObjectHelper;

public class DataLakeDirectoryClientWrapper {
    private final DataLakeDirectoryClient client;

    public DataLakeDirectoryClientWrapper(DataLakeDirectoryClient directoryClient) {
        ObjectHelper.notNull(directoryClient, "directory client cant be null");
        this.client = directoryClient;
    }

    public Response<DataLakeFileClient> createFileWithResponse(String fileName, String permission, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout) {
        return this.client.createFileWithResponse(fileName, permission, umask, headers, metadata, requestConditions, timeout, Context.NONE);
    }

    public Response<Void> deleteWithResponse(Boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout) {
        return this.client.deleteWithResponse(recursive, requestConditions, timeout, Context.NONE);
    }

    public DataLakeFileClientWrapper getDataLakeFileClientWrapper(String fileName) {
        if (!ObjectHelper.isEmpty(fileName)) {
            return new DataLakeFileClientWrapper(this.client.getFileClient(fileName));
        }
        throw new IllegalArgumentException("Cannot initialize a file since no file name was provided.");
    }
}

