/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.client;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DownloadRetryOptions;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.models.FileReadResponse;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.options.DataLakeFileAppendOptions;
import com.azure.storage.file.datalake.options.FileParallelUploadOptions;
import com.azure.storage.file.datalake.options.FileQueryOptions;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.apache.camel.util.SkipLastByteInputStream;

public class DataLakeFileClientWrapper {
    private final DataLakeFileClient client;

    public DataLakeFileClientWrapper(DataLakeFileClient client) {
        this.client = client;
    }

    public String getFileName() {
        return this.client.getFileName();
    }

    public String getFileUrl() {
        return this.client.getFileUrl();
    }

    public Long getFileSize() {
        return this.client.getProperties().getFileSize();
    }

    public Response<Void> delete(DataLakeRequestConditions accessConditions, Duration timeout) {
        return this.client.deleteWithResponse(accessConditions, timeout, Context.NONE);
    }

    public InputStream openInputStream() {
        String query = "SELECT * from BlobStorage";
        InputStream sourceInputStream = this.client.openQueryInputStream(query);
        return new SkipLastByteInputStream(sourceInputStream, 10);
    }

    public Response<InputStream> openQueryInputStreamWithResponse(FileQueryOptions queryOptions) {
        return this.client.openQueryInputStreamWithResponse(queryOptions);
    }

    public FileReadResponse downloadWithResponse(OutputStream outputStream, FileRange fileRange, DownloadRetryOptions downloadRetryOptions, DataLakeRequestConditions requestConditions, boolean rangeGetContentMd5, Duration timeout) {
        return this.client.readWithResponse(outputStream, fileRange, downloadRetryOptions, requestConditions, rangeGetContentMd5, timeout, Context.NONE);
    }

    public Response<PathProperties> downloadToFileWithResponse(String filePath, FileRange fileRange, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, DataLakeRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Duration timeout) {
        return this.client.readToFileWithResponse(filePath, fileRange, parallelTransferOptions, downloadRetryOptions, requestConditions, rangeGetContentMd5, openOptions, timeout, Context.NONE);
    }

    public Response<PathInfo> createWithResponse(String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout) {
        return this.client.createWithResponse(permissions, umask, headers, metadata, requestConditions, timeout, Context.NONE);
    }

    public Response<PathInfo> flushWithResponse(long position, Boolean retainUncommitedData, Boolean close, PathHttpHeaders headers, DataLakeRequestConditions requestConditions, Duration timeout) {
        return this.client.flushWithResponse(position, retainUncommitedData, close, headers, requestConditions, timeout, Context.NONE);
    }

    public Response<Void> appendWithResponse(InputStream stream, Long fileOffset, Long length, Duration timeout, DataLakeFileAppendOptions options) {
        return this.client.appendWithResponse(stream, (long)fileOffset, length, options, timeout, Context.NONE);
    }

    public Response<PathInfo> uploadWithResponse(FileParallelUploadOptions uploadOptions, Duration timeout) {
        return this.client.uploadWithResponse(uploadOptions, timeout, Context.NONE);
    }

    public Response<DataLakeFileClient> renameWithResponse(String destFileSystem, String destPath, DataLakeRequestConditions sourceAccessConditions, DataLakeRequestConditions destAccessConditions, Duration timeout) {
        return this.client.renameWithResponse(destFileSystem, destPath, sourceAccessConditions, destAccessConditions, timeout, Context.NONE);
    }

    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout) {
        this.client.uploadFromFile(filePath, parallelTransferOptions, headers, metadata, requestConditions, timeout);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.client.generateSas(dataLakeServiceSasSignatureValues);
    }
}

