/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.client;

import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.FileSystemItem;
import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeFileSystemClientWrapper;
import org.apache.camel.util.ObjectHelper;

public class DataLakeServiceClientWrapper {
    private final DataLakeServiceClient client;

    public DataLakeServiceClientWrapper(DataLakeServiceClient client) {
        ObjectHelper.notNull(client, "client cannot be null");
        this.client = client;
    }

    public List<FileSystemItem> listFileSystems(ListFileSystemsOptions options, Duration timeout) {
        return this.client.listFileSystems(options, timeout).stream().collect(Collectors.toList());
    }

    public DataLakeFileSystemClientWrapper getDataLakeFileSystemClientWrapper(String fileSystemName) {
        if (!ObjectHelper.isEmpty(fileSystemName)) {
            return new DataLakeFileSystemClientWrapper(this.client.getFileSystemClient(fileSystemName));
        }
        throw new IllegalArgumentException("cannot inititialize a fileSystem since no file system name was provided");
    }
}

