/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.operations;

import com.azure.core.http.rest.Response;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.datalake.DataLakeExchangeHeaders;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeDirectoryClientWrapper;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DataLakeDirectoryOperations {
    private final DataLakeDirectoryClientWrapper client;
    private final DataLakeConfigurationOptionsProxy configurationProxy;

    public DataLakeDirectoryOperations(DataLakeConfiguration configuration, DataLakeDirectoryClientWrapper client) {
        ObjectHelper.notNull(client, "client cannot be null");
        this.client = client;
        this.configurationProxy = new DataLakeConfigurationOptionsProxy(configuration);
    }

    public DataLakeOperationResponse createFile(Exchange exchange) {
        String fileName = this.configurationProxy.getFileName(exchange);
        String permission = this.configurationProxy.getPermission(exchange);
        String umask = this.configurationProxy.getUmask(exchange);
        PathHttpHeaders httpHeaders = this.configurationProxy.getPathHttpHeaders(exchange);
        Map<String, String> metadata = this.configurationProxy.getMetadata(exchange);
        DataLakeRequestConditions requestConditions = this.configurationProxy.getDataLakeRequestConditions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        Response<DataLakeFileClient> response = this.client.createFileWithResponse(fileName, permission, umask, httpHeaders, metadata, requestConditions, timeout);
        DataLakeFileClient fileClient = response.getValue();
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.create().httpHeaders(response.getHeaders()).fileClient(fileClient);
        return new DataLakeOperationResponse(fileClient, exchangeHeaders.toMap());
    }

    public DataLakeOperationResponse deleteDirectory(Exchange exchange) {
        Boolean recursive = this.configurationProxy.isRecursive(exchange);
        DataLakeRequestConditions requestConditions = this.configurationProxy.getDataLakeRequestConditions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        Response<Void> response = this.client.deleteWithResponse(recursive, requestConditions, timeout);
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.create().httpHeaders(response.getHeaders());
        return new DataLakeOperationResponse(true, exchangeHeaders.toMap());
    }
}

