/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.azure.storage.file.datalake.implementation.models.LeaseAccessConditions;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathExpiryOptions;
import com.azure.storage.file.datalake.implementation.models.PathGetPropertiesAction;
import com.azure.storage.file.datalake.implementation.models.PathRenameMode;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathSetAccessControlRecursiveMode;
import com.azure.storage.file.datalake.implementation.models.PathsCreateHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsDeleteHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlHeaders;
import com.azure.storage.file.datalake.implementation.models.SourceModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.implementation.util.ModelHelper;
import com.azure.storage.file.datalake.models.AccessControlChangeResult;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.PathAccessControl;
import com.azure.storage.file.datalake.models.PathAccessControlEntry;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathPermissions;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.models.PathRemoveAccessControlEntry;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import com.azure.storage.file.datalake.options.PathGetPropertiesOptions;
import com.azure.storage.file.datalake.options.PathRemoveAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.options.PathSetAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.options.PathUpdateAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakePathClientBuilder.class)
public class DataLakePathClient {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakePathClient.class);
    final DataLakePathAsyncClient dataLakePathAsyncClient;
    final BlockBlobClient blockBlobClient;
    final AzureDataLakeStorageRestAPIImpl dataLakeStorage;
    final AzureDataLakeStorageRestAPIImpl fileSystemDataLakeStorage;
    final AzureDataLakeStorageRestAPIImpl blobDataLakeStorage;
    private final String accountName;
    private final String fileSystemName;
    final String pathName;
    private final String objectName;
    private final DataLakeServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    final PathResourceType pathResourceType;
    private final AzureSasCredential sasToken;
    private final boolean isTokenCredentialAuthenticated;

    DataLakePathClient(DataLakePathAsyncClient dataLakePathAsyncClient, BlockBlobClient blockBlobClient, HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String pathName, PathResourceType pathResourceType, AzureSasCredential sasToken, CpkInfo customerProvidedKey, boolean isTokenCredentialAuthenticated) {
        this.dataLakePathAsyncClient = dataLakePathAsyncClient;
        this.blockBlobClient = blockBlobClient;
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.pathName = pathName;
        this.pathResourceType = pathResourceType;
        this.sasToken = sasToken;
        this.dataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).path(this.pathName).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(url, "blob", "dfs");
        this.blobDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(blobUrl).fileSystem(fileSystemName).path(this.pathName).version(serviceVersion.getVersion()).buildClient();
        this.fileSystemDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        this.customerProvidedKey = customerProvidedKey;
        this.isTokenCredentialAuthenticated = isTokenCredentialAuthenticated;
        String[] pathParts = pathName.split("/");
        this.objectName = pathParts[pathParts.length - 1];
    }

    String getAccountUrl() {
        return this.dataLakeStorage.getUrl();
    }

    String getPathUrl() {
        return this.dataLakeStorage.getUrl() + "/" + this.fileSystemName + "/" + Utility.urlEncode(this.pathName);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    String getObjectPath() {
        return this.pathName;
    }

    String getObjectName() {
        return this.objectName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.dataLakeStorage.getHttpPipeline();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    AzureSasCredential getSasToken() {
        return this.sasToken;
    }

    public CustomerProvidedKey getCustomerProvidedKey() {
        return new CustomerProvidedKey(this.customerProvidedKey.getEncryptionKey());
    }

    CpkInfo getCpkInfo() {
        return this.customerProvidedKey;
    }

    boolean isTokenCredentialAuthenticated() {
        return this.isTokenCredentialAuthenticated;
    }

    public DataLakePathClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new DataLakePathClient(this.dataLakePathAsyncClient, this.blockBlobClient.getCustomerProvidedKeyClient(Transforms.toBlobCustomerProvidedKey(customerProvidedKey)), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath(), this.pathResourceType, this.getSasToken(), finalCustomerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo create() {
        return this.create(false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo create(boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createWithResponse(new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> createWithResponse(String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createWithResponse(options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> createWithResponse(DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakePathCreateOptions finalOptions = options == null ? new DataLakePathCreateOptions() : options;
        DataLakeRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new DataLakeRequestConditions() : finalOptions.getRequestConditions();
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        String acl = finalOptions.getAccessControlList() != null ? PathAccessControlEntry.serializeList(finalOptions.getAccessControlList()) : null;
        PathExpiryOptions expiryOptions = ModelHelper.setFieldsIfNull(finalOptions, this.pathResourceType);
        String expiresOnString = null;
        if (finalOptions.getScheduleDeletionOptions() != null && finalOptions.getScheduleDeletionOptions().getExpiresOn() != null) {
            expiresOnString = DateTimeRfc1123.toRfc1123String(finalOptions.getScheduleDeletionOptions().getExpiresOn());
        } else if (finalOptions.getScheduleDeletionOptions() != null && finalOptions.getScheduleDeletionOptions().getTimeToExpire() != null) {
            expiresOnString = Long.toString(finalOptions.getScheduleDeletionOptions().getTimeToExpire().toMillis());
        }
        String finalExpiresOnString = expiresOnString;
        Long leaseDuration = finalOptions.getLeaseDuration() != null ? Long.valueOf(finalOptions.getLeaseDuration().intValue()) : null;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.dataLakeStorage.getPaths().createWithResponse(null, null, this.pathResourceType, null, null, null, finalOptions.getSourceLeaseId(), ModelHelper.buildMetadataString(finalOptions.getMetadata()), finalOptions.getPermissions(), finalOptions.getUmask(), finalOptions.getOwner(), finalOptions.getGroup(), acl, finalOptions.getProposedLeaseId(), leaseDuration, expiryOptions, finalExpiresOnString, finalOptions.getEncryptionContext(), finalOptions.getPathHttpHeaders(), lac, mac, null, this.customerProvidedKey, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
        return new SimpleResponse<PathInfo>(response, new PathInfo(((PathsCreateHeaders)response.getDeserializedHeaders()).getETag(), ((PathsCreateHeaders)response.getDeserializedHeaders()).getLastModified(), ((PathsCreateHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted() != null, ((PathsCreateHeaders)response.getDeserializedHeaders()).getXMsEncryptionKeySha256()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo createIfNotExists() {
        return this.createIfNotExistsWithResponse(new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> createIfNotExistsWithResponse(DataLakePathCreateOptions options, Duration timeout, Context context) {
        try {
            options = options == null ? new DataLakePathCreateOptions() : options;
            options.setRequestConditions(new DataLakeRequestConditions().setIfNoneMatch("*"));
            return this.createWithResponse(options, timeout, context);
        }
        catch (DataLakeStorageException e) {
            if (e.getStatusCode() == 409) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Object>(res.getRequest(), res.getStatusCode(), res.getHeaders(), null);
            }
            throw LOGGER.logExceptionAsError(e);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Duration timeout, Context context) {
        options = options == null ? new DataLakePathDeleteOptions() : options;
        try {
            Response<Void> response = this.deleteWithResponse(options.getIsRecursive(), options.getRequestConditions(), timeout, context);
            return new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), true);
        }
        catch (DataLakeStorageException e) {
            if (e.getStatusCode() == 404) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Boolean>(res.getRequest(), res.getStatusCode(), res.getHeaders(), false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    Response<Void> deleteWithResponse(Boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        Boolean paginated = this.getServiceVersion().ordinal() >= DataLakeServiceVersion.V2023_08_03.ordinal() && Boolean.TRUE.equals(recursive) && this.isTokenCredentialAuthenticated() ? Boolean.valueOf(true) : null;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> {
            ResponseBase<PathsDeleteHeaders, Void> lastResponse;
            String continuation = null;
            while ((continuation = (lastResponse = this.dataLakeStorage.getPaths().deleteWithResponse(null, null, recursive, continuation, paginated, lac, mac, finalContext)).getHeaders().getValue(Transforms.X_MS_CONTINUATION)) != null && !continuation.isEmpty()) {
            }
            return lastResponse;
        };
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
        return new SimpleResponse<Object>(response, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blockBlobClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions), timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setHttpHeaders(PathHttpHeaders headers) {
        this.setHttpHeadersWithResponse(headers, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setHttpHeadersWithResponse(PathHttpHeaders headers, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blockBlobClient.setHttpHeadersWithResponse(Transforms.toBlobHttpHeaders(headers), Transforms.toBlobRequestConditions(requestConditions), timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo setAccessControlList(List<PathAccessControlEntry> accessControlList, String group, String owner) {
        return this.setAccessControlListWithResponse(accessControlList, group, owner, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> setAccessControlListWithResponse(List<PathAccessControlEntry> accessControlList, String group, String owner, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.setAccessControlWithResponse(accessControlList, null, group, owner, requestConditions, timeout, context);
    }

    Response<PathInfo> setAccessControlWithResponse(List<PathAccessControlEntry> accessControlList, PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        String permissionsString = permissions == null ? null : permissions.toString();
        String accessControlListString = accessControlList == null ? null : PathAccessControlEntry.serializeList(accessControlList);
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.dataLakeStorage.getPaths().setAccessControlWithResponse(null, owner, group, permissionsString, accessControlListString, null, lac, mac, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
        return new SimpleResponse<PathInfo>(response, new PathInfo(((PathsSetAccessControlHeaders)response.getDeserializedHeaders()).getETag(), ((PathsSetAccessControlHeaders)response.getDeserializedHeaders()).getLastModified()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo setPermissions(PathPermissions permissions, String group, String owner) {
        return this.setPermissionsWithResponse(permissions, group, owner, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> setPermissionsWithResponse(PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.setAccessControlWithResponse(null, permissions, group, owner, requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessControlChangeResult setAccessControlRecursive(List<PathAccessControlEntry> accessControlList) {
        return this.setAccessControlRecursiveWithResponse(new PathSetAccessControlRecursiveOptions(accessControlList), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessControlChangeResult> setAccessControlRecursiveWithResponse(PathSetAccessControlRecursiveOptions options, Duration timeout, Context context) {
        Mono<Response<AccessControlChangeResult>> response = this.dataLakePathAsyncClient.setAccessControlRecursiveWithResponse(PathAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.SET, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessControlChangeResult updateAccessControlRecursive(List<PathAccessControlEntry> accessControlList) {
        return this.updateAccessControlRecursiveWithResponse(new PathUpdateAccessControlRecursiveOptions(accessControlList), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessControlChangeResult> updateAccessControlRecursiveWithResponse(PathUpdateAccessControlRecursiveOptions options, Duration timeout, Context context) {
        Mono<Response<AccessControlChangeResult>> response = this.dataLakePathAsyncClient.setAccessControlRecursiveWithResponse(PathAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.MODIFY, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessControlChangeResult removeAccessControlRecursive(List<PathRemoveAccessControlEntry> accessControlList) {
        return this.removeAccessControlRecursiveWithResponse(new PathRemoveAccessControlRecursiveOptions(accessControlList), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessControlChangeResult> removeAccessControlRecursiveWithResponse(PathRemoveAccessControlRecursiveOptions options, Duration timeout, Context context) {
        Mono<Response<AccessControlChangeResult>> response = this.dataLakePathAsyncClient.setAccessControlRecursiveWithResponse(PathRemoveAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.REMOVE, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathAccessControl getAccessControl() {
        return this.getAccessControlWithResponse(false, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathAccessControl> getAccessControlWithResponse(boolean userPrincipalNameReturned, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.dataLakeStorage.getPaths().getPropertiesWithResponse(null, null, PathGetPropertiesAction.GET_ACCESS_CONTROL, userPrincipalNameReturned, lac, mac, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
        return new SimpleResponse<PathAccessControl>(response, new PathAccessControl(PathAccessControlEntry.parseList(((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsAcl()), PathPermissions.parseSymbolic(((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsPermissions()), ((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsGroup(), ((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsOwner()));
    }

    Response<DataLakePathClient> renameWithResponseWithTimeout(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        destinationRequestConditions = destinationRequestConditions == null ? new DataLakeRequestConditions() : destinationRequestConditions;
        DataLakeRequestConditions finalSourceRequestConditions = sourceRequestConditions == null ? new DataLakeRequestConditions() : sourceRequestConditions;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().setSourceIfModifiedSince(finalSourceRequestConditions.getIfModifiedSince()).setSourceIfUnmodifiedSince(finalSourceRequestConditions.getIfUnmodifiedSince()).setSourceIfMatch(finalSourceRequestConditions.getIfMatch()).setSourceIfNoneMatch(finalSourceRequestConditions.getIfNoneMatch());
        LeaseAccessConditions destLac = new LeaseAccessConditions().setLeaseId(destinationRequestConditions.getLeaseId());
        ModifiedAccessConditions destMac = new ModifiedAccessConditions().setIfMatch(destinationRequestConditions.getIfMatch()).setIfNoneMatch(destinationRequestConditions.getIfNoneMatch()).setIfModifiedSince(destinationRequestConditions.getIfModifiedSince()).setIfUnmodifiedSince(destinationRequestConditions.getIfUnmodifiedSince());
        DataLakePathClient dataLakePathClient = this.getPathClient(destinationFileSystem, destinationPath);
        String renameSource = "/" + this.getFileSystemName() + "/" + Utility.urlEncode(this.pathName);
        String signature = null;
        if (this.getSasToken() != null) {
            signature = this.getSasToken().getSignature().startsWith("?") ? this.getSasToken().getSignature().substring(1) : this.getSasToken().getSignature();
        }
        String finalRenameSource = signature != null ? renameSource + "?" + signature : renameSource;
        Callable<ResponseBase> operation = () -> dataLakePathClient.dataLakeStorage.getPaths().createWithResponse(null, null, null, null, PathRenameMode.LEGACY, finalRenameSource, finalSourceRequestConditions.getLeaseId(), null, null, null, null, null, null, null, null, null, null, null, null, destLac, destMac, sourceConditions, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
        return new SimpleResponse<DataLakePathClient>(response, dataLakePathClient);
    }

    DataLakePathClient getPathClient(String destinationFileSystem, String destinationPath) {
        if (destinationFileSystem == null) {
            destinationFileSystem = this.getFileSystemName();
        }
        if (CoreUtils.isNullOrEmpty(destinationPath)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new DataLakePathClient(this.dataLakePathAsyncClient, this.dataLakePathAsyncClient.prepareBuilderReplacePath(destinationFileSystem, destinationPath).buildBlockBlobClient(), this.getHttpPipeline(), this.getAccountUrl(), this.serviceVersion, this.accountName, destinationFileSystem, destinationPath, this.pathResourceType, this.sasToken, this.customerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathProperties getProperties() {
        return this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathProperties getProperties(PathGetPropertiesOptions options) {
        return this.getPropertiesUsingOptionsWithResponse(options, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathProperties> getPropertiesWithResponse(DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobProperties> response = this.blockBlobClient.getPropertiesWithResponse(Transforms.toBlobRequestConditions(requestConditions), timeout, context);
            return new SimpleResponse<PathProperties>(response, Transforms.toPathProperties(response.getValue(), response));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<PathProperties> getPropertiesUsingOptionsWithResponse(PathGetPropertiesOptions options, Duration timeout, Context context) {
        Context finalContext = context = BuilderHelper.addUpnHeader(() -> options == null ? null : options.isUserPrincipalName(), context);
        PathGetPropertiesOptions finalOptions = options;
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobProperties> response = this.blockBlobClient.getPropertiesWithResponse(Transforms.toBlobRequestConditions(finalOptions.getRequestConditions()), timeout, finalContext);
            return new SimpleResponse<PathProperties>(response, Transforms.toPathProperties(response.getValue(), response));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blockBlobClient.existsWithResponse(timeout, context), LOGGER);
    }

    BlockBlobClient getBlockBlobClient() {
        return this.blockBlobClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName(), this.getObjectPath(), PathResourceType.DIRECTORY.equals((Object)this.pathResourceType)).generateUserDelegationSas(userDelegationKey, accountName, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.generateSas(dataLakeServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName(), this.getObjectPath(), PathResourceType.DIRECTORY.equals((Object)this.pathResourceType)).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), context);
    }
}

