/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.azure.storage.file.datalake.implementation.models.LeaseAccessConditions;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathExpiryOptions;
import com.azure.storage.file.datalake.implementation.models.PathGetPropertiesAction;
import com.azure.storage.file.datalake.implementation.models.PathLeaseAction;
import com.azure.storage.file.datalake.implementation.models.PathRenameMode;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathSetAccessControlRecursiveMode;
import com.azure.storage.file.datalake.implementation.models.PathUpdateAction;
import com.azure.storage.file.datalake.implementation.models.PathsAppendDataHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsCreateHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsDeleteHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsFlushDataHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsLeaseHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsReadHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlRecursiveHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetExpiryHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsUndeleteHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsUpdateHeaders;
import com.azure.storage.file.datalake.implementation.models.SetAccessControlRecursiveResponse;
import com.azure.storage.file.datalake.implementation.models.SourceModifiedAccessConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.EncryptionAlgorithmType;
import com.azure.storage.file.datalake.models.LeaseAction;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PathsImpl {
    private final PathsService service;
    private final AzureDataLakeStorageRestAPIImpl client;

    PathsImpl(AzureDataLakeStorageRestAPIImpl client) {
        this.service = RestProxy.create(PathsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsCreateHeaders, Void>> createWithResponseAsync(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo) {
        String accept = "application/json";
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String sourceIfMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchInternal = sourceModifiedAccessConditions.getSourceIfMatch();
        }
        String sourceIfMatch = sourceIfMatchInternal;
        String sourceIfNoneMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchInternal = sourceModifiedAccessConditions.getSourceIfNoneMatch();
        }
        String sourceIfNoneMatch = sourceIfNoneMatchInternal;
        OffsetDateTime sourceIfModifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfModifiedSince();
        }
        OffsetDateTime sourceIfModifiedSince = sourceIfModifiedSinceInternal;
        OffsetDateTime sourceIfUnmodifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfUnmodifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = sourceIfUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), resource, continuation, mode, cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, renameSource, leaseId, sourceLeaseId, properties, permissions, umask, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsCreateHeaders, Void>> createWithResponseAsync(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String sourceIfMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchInternal = sourceModifiedAccessConditions.getSourceIfMatch();
        }
        String sourceIfMatch = sourceIfMatchInternal;
        String sourceIfNoneMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchInternal = sourceModifiedAccessConditions.getSourceIfNoneMatch();
        }
        String sourceIfNoneMatch = sourceIfNoneMatchInternal;
        OffsetDateTime sourceIfModifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfModifiedSince();
        }
        OffsetDateTime sourceIfModifiedSince = sourceIfModifiedSinceInternal;
        OffsetDateTime sourceIfUnmodifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfUnmodifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = sourceIfUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.create(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), resource, continuation, mode, cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, renameSource, leaseId, sourceLeaseId, properties, permissions, umask, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo) {
        return this.createWithResponseAsync(requestId, timeout, resource, continuation, mode, renameSource, sourceLeaseId, properties, permissions, umask, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, sourceModifiedAccessConditions, cpkInfo).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        return this.createWithResponseAsync(requestId, timeout, resource, continuation, mode, renameSource, sourceLeaseId, properties, permissions, umask, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, sourceModifiedAccessConditions, cpkInfo, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo) {
        String accept = "application/json";
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String sourceIfMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchInternal = sourceModifiedAccessConditions.getSourceIfMatch();
        }
        String sourceIfMatch = sourceIfMatchInternal;
        String sourceIfNoneMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchInternal = sourceModifiedAccessConditions.getSourceIfNoneMatch();
        }
        String sourceIfNoneMatch = sourceIfNoneMatchInternal;
        OffsetDateTime sourceIfModifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfModifiedSince();
        }
        OffsetDateTime sourceIfModifiedSince = sourceIfModifiedSinceInternal;
        OffsetDateTime sourceIfUnmodifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfUnmodifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = sourceIfUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.createNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), resource, continuation, mode, cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, renameSource, leaseId, sourceLeaseId, properties, permissions, umask, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String sourceIfMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchInternal = sourceModifiedAccessConditions.getSourceIfMatch();
        }
        String sourceIfMatch = sourceIfMatchInternal;
        String sourceIfNoneMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchInternal = sourceModifiedAccessConditions.getSourceIfNoneMatch();
        }
        String sourceIfNoneMatch = sourceIfNoneMatchInternal;
        OffsetDateTime sourceIfModifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfModifiedSince();
        }
        OffsetDateTime sourceIfModifiedSince = sourceIfModifiedSinceInternal;
        OffsetDateTime sourceIfUnmodifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfUnmodifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = sourceIfUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.createNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), resource, continuation, mode, cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, renameSource, leaseId, sourceLeaseId, properties, permissions, umask, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsCreateHeaders, Void> createWithResponse(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String sourceIfMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchInternal = sourceModifiedAccessConditions.getSourceIfMatch();
        }
        String sourceIfMatch = sourceIfMatchInternal;
        String sourceIfNoneMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchInternal = sourceModifiedAccessConditions.getSourceIfNoneMatch();
        }
        String sourceIfNoneMatch = sourceIfNoneMatchInternal;
        OffsetDateTime sourceIfModifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfModifiedSince();
        }
        OffsetDateTime sourceIfModifiedSince = sourceIfModifiedSinceInternal;
        OffsetDateTime sourceIfUnmodifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfUnmodifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = sourceIfUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.createSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), resource, continuation, mode, cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, renameSource, leaseId, sourceLeaseId, properties, permissions, umask, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo) {
        this.createWithResponse(requestId, timeout, resource, continuation, mode, renameSource, sourceLeaseId, properties, permissions, umask, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, sourceModifiedAccessConditions, cpkInfo, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String requestId, Integer timeout, PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String owner, String group, String acl, String proposedLeaseId, Long leaseDuration, PathExpiryOptions expiryOptions, String expiresOn, String encryptionContext, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String sourceIfMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchInternal = sourceModifiedAccessConditions.getSourceIfMatch();
        }
        String sourceIfMatch = sourceIfMatchInternal;
        String sourceIfNoneMatchInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchInternal = sourceModifiedAccessConditions.getSourceIfNoneMatch();
        }
        String sourceIfNoneMatch = sourceIfNoneMatchInternal;
        OffsetDateTime sourceIfModifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfModifiedSince();
        }
        OffsetDateTime sourceIfModifiedSince = sourceIfModifiedSinceInternal;
        OffsetDateTime sourceIfUnmodifiedSinceInternal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSinceInternal = sourceModifiedAccessConditions.getSourceIfUnmodifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = sourceIfUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.createNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), resource, continuation, mode, cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, renameSource, leaseId, sourceLeaseId, properties, permissions, umask, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, owner, group, acl, proposedLeaseId, leaseDuration, expiryOptions, expiresOn, encryptionContext, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse>> updateWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.update(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse>> updateWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.update(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SetAccessControlRecursiveResponse> updateAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.updateWithResponseAsync(action, mode, body, requestId, timeout, maxRecords, continuation, forceFlag, position, retainUncommittedData, close, contentLength, properties, owner, group, permissions, acl, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions).flatMap(res -> Mono.justOrEmpty((SetAccessControlRecursiveResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SetAccessControlRecursiveResponse> updateAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.updateWithResponseAsync(action, mode, body, requestId, timeout, maxRecords, continuation, forceFlag, position, retainUncommittedData, close, contentLength, properties, owner, group, permissions, acl, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, context).flatMap(res -> Mono.justOrEmpty((SetAccessControlRecursiveResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SetAccessControlRecursiveResponse>> updateNoCustomHeadersWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.updateNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SetAccessControlRecursiveResponse>> updateNoCustomHeadersWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.updateNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse>> updateWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.update(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse>> updateWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.update(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SetAccessControlRecursiveResponse> updateAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.updateWithResponseAsync(action, mode, body, requestId, timeout, maxRecords, continuation, forceFlag, position, retainUncommittedData, close, contentLength, properties, owner, group, permissions, acl, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions).flatMap(res -> Mono.justOrEmpty((SetAccessControlRecursiveResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SetAccessControlRecursiveResponse> updateAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.updateWithResponseAsync(action, mode, body, requestId, timeout, maxRecords, continuation, forceFlag, position, retainUncommittedData, close, contentLength, properties, owner, group, permissions, acl, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, context).flatMap(res -> Mono.justOrEmpty((SetAccessControlRecursiveResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SetAccessControlRecursiveResponse>> updateNoCustomHeadersWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.updateNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SetAccessControlRecursiveResponse>> updateNoCustomHeadersWithResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.updateNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse> updateWithResponse(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.updateSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SetAccessControlRecursiveResponse update(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.updateWithResponse(action, mode, body, requestId, timeout, maxRecords, continuation, forceFlag, position, retainUncommittedData, close, contentLength, properties, owner, group, permissions, acl, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SetAccessControlRecursiveResponse> updateNoCustomHeadersWithResponse(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, BinaryData body, String requestId, Integer timeout, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.updateNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, properties, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsLeaseHeaders, Void>> leaseWithResponseAsync(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.lease(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), xMsLeaseAction, this.client.getXMsLeaseDuration(), xMsLeaseBreakPeriod, leaseId, proposedLeaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsLeaseHeaders, Void>> leaseWithResponseAsync(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.lease(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), xMsLeaseAction, this.client.getXMsLeaseDuration(), xMsLeaseBreakPeriod, leaseId, proposedLeaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> leaseAsync(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.leaseWithResponseAsync(xMsLeaseAction, requestId, timeout, xMsLeaseBreakPeriod, proposedLeaseId, leaseAccessConditions, modifiedAccessConditions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> leaseAsync(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.leaseWithResponseAsync(xMsLeaseAction, requestId, timeout, xMsLeaseBreakPeriod, proposedLeaseId, leaseAccessConditions, modifiedAccessConditions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> leaseNoCustomHeadersWithResponseAsync(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.leaseNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), xMsLeaseAction, this.client.getXMsLeaseDuration(), xMsLeaseBreakPeriod, leaseId, proposedLeaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> leaseNoCustomHeadersWithResponseAsync(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.leaseNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), xMsLeaseAction, this.client.getXMsLeaseDuration(), xMsLeaseBreakPeriod, leaseId, proposedLeaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsLeaseHeaders, Void> leaseWithResponse(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.leaseSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), xMsLeaseAction, this.client.getXMsLeaseDuration(), xMsLeaseBreakPeriod, leaseId, proposedLeaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void lease(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.leaseWithResponse(xMsLeaseAction, requestId, timeout, xMsLeaseBreakPeriod, proposedLeaseId, leaseAccessConditions, modifiedAccessConditions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> leaseNoCustomHeadersWithResponse(PathLeaseAction xMsLeaseAction, String requestId, Integer timeout, Integer xMsLeaseBreakPeriod, String proposedLeaseId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.leaseNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), xMsLeaseAction, this.client.getXMsLeaseDuration(), xMsLeaseBreakPeriod, leaseId, proposedLeaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsReadHeaders, Flux<ByteBuffer>>> readWithResponseAsync(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.read(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), range, leaseId, xMsRangeGetContentMd5, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsReadHeaders, Flux<ByteBuffer>>> readWithResponseAsync(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.read(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), range, leaseId, xMsRangeGetContentMd5, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> readAsync(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        return this.readWithResponseAsync(requestId, timeout, range, xMsRangeGetContentMd5, leaseAccessConditions, modifiedAccessConditions, cpkInfo).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> readAsync(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        return this.readWithResponseAsync(requestId, timeout, range, xMsRangeGetContentMd5, leaseAccessConditions, modifiedAccessConditions, cpkInfo, context).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> readNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.readNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), range, leaseId, xMsRangeGetContentMd5, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> readNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.readNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), range, leaseId, xMsRangeGetContentMd5, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsReadHeaders, InputStream> readWithResponse(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.readSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), range, leaseId, xMsRangeGetContentMd5, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream read(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        return this.readWithResponse(requestId, timeout, range, xMsRangeGetContentMd5, leaseAccessConditions, modifiedAccessConditions, cpkInfo, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InputStream> readNoCustomHeadersWithResponse(String requestId, Integer timeout, String range, Boolean xMsRangeGetContentMd5, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.readNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), range, leaseId, xMsRangeGetContentMd5, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.getPropertiesWithResponseAsync(requestId, timeout, action, upn, leaseAccessConditions, modifiedAccessConditions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.getPropertiesWithResponseAsync(requestId, timeout, action, upn, leaseAccessConditions, modifiedAccessConditions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsGetPropertiesHeaders, Void> getPropertiesWithResponse(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPropertiesSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getProperties(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.getPropertiesWithResponse(requestId, timeout, action, upn, leaseAccessConditions, modifiedAccessConditions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String requestId, Integer timeout, PathGetPropertiesAction action, Boolean upn, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), action, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsDeleteHeaders, Void>> deleteWithResponseAsync(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), recursive, continuation, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, paginated, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsDeleteHeaders, Void>> deleteWithResponseAsync(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), recursive, continuation, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, paginated, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.deleteWithResponseAsync(requestId, timeout, recursive, continuation, paginated, leaseAccessConditions, modifiedAccessConditions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.deleteWithResponseAsync(requestId, timeout, recursive, continuation, paginated, leaseAccessConditions, modifiedAccessConditions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.deleteNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), recursive, continuation, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, paginated, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), recursive, continuation, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, paginated, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsDeleteHeaders, Void> deleteWithResponse(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.deleteSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), recursive, continuation, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, paginated, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.deleteWithResponse(requestId, timeout, recursive, continuation, paginated, leaseAccessConditions, modifiedAccessConditions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String requestId, Integer timeout, Boolean recursive, String continuation, Boolean paginated, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.deleteNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), requestId, timeout, this.client.getVersion(), recursive, continuation, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, paginated, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsSetAccessControlHeaders, Void>> setAccessControlWithResponseAsync(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String action = "setAccessControl";
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.setAccessControl(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControl", timeout, leaseId, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsSetAccessControlHeaders, Void>> setAccessControlWithResponseAsync(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String action = "setAccessControl";
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControl(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControl", timeout, leaseId, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessControlAsync(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.setAccessControlWithResponseAsync(timeout, owner, group, permissions, acl, requestId, leaseAccessConditions, modifiedAccessConditions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessControlAsync(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.setAccessControlWithResponseAsync(timeout, owner, group, permissions, acl, requestId, leaseAccessConditions, modifiedAccessConditions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessControlNoCustomHeadersWithResponseAsync(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        String action = "setAccessControl";
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.setAccessControlNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControl", timeout, leaseId, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessControlNoCustomHeadersWithResponseAsync(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String action = "setAccessControl";
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControlNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControl", timeout, leaseId, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsSetAccessControlHeaders, Void> setAccessControlWithResponse(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String action = "setAccessControl";
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControlSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControl", timeout, leaseId, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessControl(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.setAccessControlWithResponse(timeout, owner, group, permissions, acl, requestId, leaseAccessConditions, modifiedAccessConditions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessControlNoCustomHeadersWithResponse(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String action = "setAccessControl";
        String accept = "application/json";
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControlNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControl", timeout, leaseId, owner, group, permissions, acl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse>> setAccessControlRecursiveWithResponseAsync(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId) {
        String action = "setAccessControlRecursive";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setAccessControlRecursive(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControlRecursive", timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse>> setAccessControlRecursiveWithResponseAsync(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId, Context context) {
        String action = "setAccessControlRecursive";
        String accept = "application/json";
        return this.service.setAccessControlRecursive(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControlRecursive", timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SetAccessControlRecursiveResponse> setAccessControlRecursiveAsync(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId) {
        return this.setAccessControlRecursiveWithResponseAsync(mode, timeout, continuation, forceFlag, maxRecords, acl, requestId).flatMap(res -> Mono.justOrEmpty((SetAccessControlRecursiveResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SetAccessControlRecursiveResponse> setAccessControlRecursiveAsync(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId, Context context) {
        return this.setAccessControlRecursiveWithResponseAsync(mode, timeout, continuation, forceFlag, maxRecords, acl, requestId, context).flatMap(res -> Mono.justOrEmpty((SetAccessControlRecursiveResponse)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SetAccessControlRecursiveResponse>> setAccessControlRecursiveNoCustomHeadersWithResponseAsync(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId) {
        String action = "setAccessControlRecursive";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setAccessControlRecursiveNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControlRecursive", timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SetAccessControlRecursiveResponse>> setAccessControlRecursiveNoCustomHeadersWithResponseAsync(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId, Context context) {
        String action = "setAccessControlRecursive";
        String accept = "application/json";
        return this.service.setAccessControlRecursiveNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControlRecursive", timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse> setAccessControlRecursiveWithResponse(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId, Context context) {
        String action = "setAccessControlRecursive";
        String accept = "application/json";
        return this.service.setAccessControlRecursiveSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControlRecursive", timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SetAccessControlRecursiveResponse setAccessControlRecursive(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId) {
        return this.setAccessControlRecursiveWithResponse(mode, timeout, continuation, forceFlag, maxRecords, acl, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SetAccessControlRecursiveResponse> setAccessControlRecursiveNoCustomHeadersWithResponse(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId, Context context) {
        String action = "setAccessControlRecursive";
        String accept = "application/json";
        return this.service.setAccessControlRecursiveNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "setAccessControlRecursive", timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsFlushDataHeaders, Void>> flushDataWithResponseAsync(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        String action = "flush";
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.flushData(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "flush", timeout, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsFlushDataHeaders, Void>> flushDataWithResponseAsync(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "flush";
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.flushData(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "flush", timeout, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> flushDataAsync(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        return this.flushDataWithResponseAsync(timeout, position, retainUncommittedData, close, contentLength, leaseAction, leaseDuration, proposedLeaseId, requestId, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, cpkInfo).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> flushDataAsync(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        return this.flushDataWithResponseAsync(timeout, position, retainUncommittedData, close, contentLength, leaseAction, leaseDuration, proposedLeaseId, requestId, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, cpkInfo, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> flushDataNoCustomHeadersWithResponseAsync(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        String action = "flush";
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.flushDataNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "flush", timeout, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> flushDataNoCustomHeadersWithResponseAsync(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "flush";
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.flushDataNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "flush", timeout, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsFlushDataHeaders, Void> flushDataWithResponse(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "flush";
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.flushDataSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "flush", timeout, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void flushData(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo) {
        this.flushDataWithResponse(timeout, position, retainUncommittedData, close, contentLength, leaseAction, leaseDuration, proposedLeaseId, requestId, pathHttpHeaders, leaseAccessConditions, modifiedAccessConditions, cpkInfo, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> flushDataNoCustomHeadersWithResponse(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "flush";
        String accept = "application/json";
        byte[] contentMd5Internal = null;
        if (pathHttpHeaders != null) {
            contentMd5Internal = pathHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String cacheControlInternal = null;
        if (pathHttpHeaders != null) {
            cacheControlInternal = pathHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (pathHttpHeaders != null) {
            contentTypeInternal = pathHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentDispositionInternal = null;
        if (pathHttpHeaders != null) {
            contentDispositionInternal = pathHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentEncodingInternal = null;
        if (pathHttpHeaders != null) {
            contentEncodingInternal = pathHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (pathHttpHeaders != null) {
            contentLanguageInternal = pathHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String ifMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifMatchInternal = modifiedAccessConditions.getIfMatch();
        }
        String ifMatch = ifMatchInternal;
        String ifNoneMatchInternal = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatchInternal = modifiedAccessConditions.getIfNoneMatch();
        }
        String ifNoneMatch = ifNoneMatchInternal;
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.flushDataNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "flush", timeout, position, retainUncommittedData, close, contentLength, contentMd5Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsAppendDataHeaders, Void>> appendDataWithResponseAsync(Flux<ByteBuffer> body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.appendData(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsAppendDataHeaders, Void>> appendDataWithResponseAsync(Flux<ByteBuffer> body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.appendData(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> appendDataAsync(Flux<ByteBuffer> body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo) {
        return this.appendDataWithResponseAsync(body, position, timeout, contentLength, transactionalContentCrc64, leaseAction, leaseDuration, proposedLeaseId, requestId, flush, pathHttpHeaders, leaseAccessConditions, cpkInfo).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> appendDataAsync(Flux<ByteBuffer> body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        return this.appendDataWithResponseAsync(body, position, timeout, contentLength, transactionalContentCrc64, leaseAction, leaseDuration, proposedLeaseId, requestId, flush, pathHttpHeaders, leaseAccessConditions, cpkInfo, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendDataNoCustomHeadersWithResponseAsync(Flux<ByteBuffer> body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.appendDataNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendDataNoCustomHeadersWithResponseAsync(Flux<ByteBuffer> body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.appendDataNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsAppendDataHeaders, Void>> appendDataWithResponseAsync(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.appendData(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsAppendDataHeaders, Void>> appendDataWithResponseAsync(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.appendData(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> appendDataAsync(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo) {
        return this.appendDataWithResponseAsync(body, position, timeout, contentLength, transactionalContentCrc64, leaseAction, leaseDuration, proposedLeaseId, requestId, flush, pathHttpHeaders, leaseAccessConditions, cpkInfo).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> appendDataAsync(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        return this.appendDataWithResponseAsync(body, position, timeout, contentLength, transactionalContentCrc64, leaseAction, leaseDuration, proposedLeaseId, requestId, flush, pathHttpHeaders, leaseAccessConditions, cpkInfo, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendDataNoCustomHeadersWithResponseAsync(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> this.service.appendDataNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendDataNoCustomHeadersWithResponseAsync(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.appendDataNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsAppendDataHeaders, Void> appendDataWithResponse(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.appendDataSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void appendData(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo) {
        this.appendDataWithResponse(body, position, timeout, contentLength, transactionalContentCrc64, leaseAction, leaseDuration, proposedLeaseId, requestId, flush, pathHttpHeaders, leaseAccessConditions, cpkInfo, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendDataNoCustomHeadersWithResponse(BinaryData body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, LeaseAction leaseAction, Long leaseDuration, String proposedLeaseId, String requestId, Boolean flush, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, CpkInfo cpkInfo, Context context) {
        String action = "append";
        String accept = "application/json";
        byte[] transactionalContentHashInternal = null;
        if (pathHttpHeaders != null) {
            transactionalContentHashInternal = pathHttpHeaders.getTransactionalContentHash();
        }
        byte[] transactionalContentHash = transactionalContentHashInternal;
        String leaseIdInternal = null;
        if (leaseAccessConditions != null) {
            leaseIdInternal = leaseAccessConditions.getLeaseId();
        }
        String leaseId = leaseIdInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String transactionalContentHashConverted = Base64Util.encodeToString(transactionalContentHash);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return this.service.appendDataNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "append", position, timeout, contentLength, transactionalContentHashConverted, transactionalContentCrc64Converted, leaseId, leaseAction, leaseDuration, proposedLeaseId, requestId, this.client.getVersion(), encryptionKey, encryptionKeySha256, encryptionAlgorithm, flush, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsSetExpiryHeaders, Void>> setExpiryWithResponseAsync(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn) {
        String comp = "expiry";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setExpiry(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "expiry", timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsSetExpiryHeaders, Void>> setExpiryWithResponseAsync(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        String comp = "expiry";
        String accept = "application/json";
        return this.service.setExpiry(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "expiry", timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setExpiryAsync(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn) {
        return this.setExpiryWithResponseAsync(expiryOptions, timeout, requestId, expiresOn).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setExpiryAsync(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        return this.setExpiryWithResponseAsync(expiryOptions, timeout, requestId, expiresOn, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setExpiryNoCustomHeadersWithResponseAsync(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn) {
        String comp = "expiry";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setExpiryNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "expiry", timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setExpiryNoCustomHeadersWithResponseAsync(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        String comp = "expiry";
        String accept = "application/json";
        return this.service.setExpiryNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "expiry", timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsSetExpiryHeaders, Void> setExpiryWithResponse(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        String comp = "expiry";
        String accept = "application/json";
        return this.service.setExpirySync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "expiry", timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setExpiry(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn) {
        this.setExpiryWithResponse(expiryOptions, timeout, requestId, expiresOn, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setExpiryNoCustomHeadersWithResponse(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        String comp = "expiry";
        String accept = "application/json";
        return this.service.setExpiryNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "expiry", timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsUndeleteHeaders, Void>> undeleteWithResponseAsync(Integer timeout, String undeleteSource, String requestId) {
        String comp = "undelete";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.undelete(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "undelete", timeout, undeleteSource, this.client.getVersion(), requestId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<PathsUndeleteHeaders, Void>> undeleteWithResponseAsync(Integer timeout, String undeleteSource, String requestId, Context context) {
        String comp = "undelete";
        String accept = "application/json";
        return this.service.undelete(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "undelete", timeout, undeleteSource, this.client.getVersion(), requestId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> undeleteAsync(Integer timeout, String undeleteSource, String requestId) {
        return this.undeleteWithResponseAsync(timeout, undeleteSource, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> undeleteAsync(Integer timeout, String undeleteSource, String requestId, Context context) {
        return this.undeleteWithResponseAsync(timeout, undeleteSource, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> undeleteNoCustomHeadersWithResponseAsync(Integer timeout, String undeleteSource, String requestId) {
        String comp = "undelete";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.undeleteNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "undelete", timeout, undeleteSource, this.client.getVersion(), requestId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> undeleteNoCustomHeadersWithResponseAsync(Integer timeout, String undeleteSource, String requestId, Context context) {
        String comp = "undelete";
        String accept = "application/json";
        return this.service.undeleteNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "undelete", timeout, undeleteSource, this.client.getVersion(), requestId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<PathsUndeleteHeaders, Void> undeleteWithResponse(Integer timeout, String undeleteSource, String requestId, Context context) {
        String comp = "undelete";
        String accept = "application/json";
        return this.service.undeleteSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "undelete", timeout, undeleteSource, this.client.getVersion(), requestId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void undelete(Integer timeout, String undeleteSource, String requestId) {
        this.undeleteWithResponse(timeout, undeleteSource, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> undeleteNoCustomHeadersWithResponse(Integer timeout, String undeleteSource, String requestId, Context context) {
        String comp = "undelete";
        String accept = "application/json";
        return this.service.undeleteNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getPath(), "undelete", timeout, undeleteSource, this.client.getVersion(), requestId, "application/json", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureDataLakeStorage")
    public static interface PathsService {
        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="resource") PathResourceType var7, @QueryParam(value="continuation") String var8, @QueryParam(value="mode") PathRenameMode var9, @HeaderParam(value="x-ms-cache-control") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-content-type") String var14, @HeaderParam(value="x-ms-rename-source") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-source-lease-id") String var17, @HeaderParam(value="x-ms-properties") String var18, @HeaderParam(value="x-ms-permissions") String var19, @HeaderParam(value="x-ms-umask") String var20, @HeaderParam(value="If-Match") String var21, @HeaderParam(value="If-None-Match") String var22, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var24, @HeaderParam(value="x-ms-source-if-match") String var25, @HeaderParam(value="x-ms-source-if-none-match") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-encryption-key") String var29, @HeaderParam(value="x-ms-encryption-key-sha256") String var30, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var31, @HeaderParam(value="x-ms-owner") String var32, @HeaderParam(value="x-ms-group") String var33, @HeaderParam(value="x-ms-acl") String var34, @HeaderParam(value="x-ms-proposed-lease-id") String var35, @HeaderParam(value="x-ms-lease-duration") Long var36, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var37, @HeaderParam(value="x-ms-expiry-time") String var38, @HeaderParam(value="x-ms-encryption-context") String var39, @HeaderParam(value="Accept") String var40, Context var41);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> createNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="resource") PathResourceType var7, @QueryParam(value="continuation") String var8, @QueryParam(value="mode") PathRenameMode var9, @HeaderParam(value="x-ms-cache-control") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-content-type") String var14, @HeaderParam(value="x-ms-rename-source") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-source-lease-id") String var17, @HeaderParam(value="x-ms-properties") String var18, @HeaderParam(value="x-ms-permissions") String var19, @HeaderParam(value="x-ms-umask") String var20, @HeaderParam(value="If-Match") String var21, @HeaderParam(value="If-None-Match") String var22, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var24, @HeaderParam(value="x-ms-source-if-match") String var25, @HeaderParam(value="x-ms-source-if-none-match") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-encryption-key") String var29, @HeaderParam(value="x-ms-encryption-key-sha256") String var30, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var31, @HeaderParam(value="x-ms-owner") String var32, @HeaderParam(value="x-ms-group") String var33, @HeaderParam(value="x-ms-acl") String var34, @HeaderParam(value="x-ms-proposed-lease-id") String var35, @HeaderParam(value="x-ms-lease-duration") Long var36, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var37, @HeaderParam(value="x-ms-expiry-time") String var38, @HeaderParam(value="x-ms-encryption-context") String var39, @HeaderParam(value="Accept") String var40, Context var41);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsCreateHeaders, Void> createSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="resource") PathResourceType var7, @QueryParam(value="continuation") String var8, @QueryParam(value="mode") PathRenameMode var9, @HeaderParam(value="x-ms-cache-control") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-content-type") String var14, @HeaderParam(value="x-ms-rename-source") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-source-lease-id") String var17, @HeaderParam(value="x-ms-properties") String var18, @HeaderParam(value="x-ms-permissions") String var19, @HeaderParam(value="x-ms-umask") String var20, @HeaderParam(value="If-Match") String var21, @HeaderParam(value="If-None-Match") String var22, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var24, @HeaderParam(value="x-ms-source-if-match") String var25, @HeaderParam(value="x-ms-source-if-none-match") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-encryption-key") String var29, @HeaderParam(value="x-ms-encryption-key-sha256") String var30, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var31, @HeaderParam(value="x-ms-owner") String var32, @HeaderParam(value="x-ms-group") String var33, @HeaderParam(value="x-ms-acl") String var34, @HeaderParam(value="x-ms-proposed-lease-id") String var35, @HeaderParam(value="x-ms-lease-duration") Long var36, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var37, @HeaderParam(value="x-ms-expiry-time") String var38, @HeaderParam(value="x-ms-encryption-context") String var39, @HeaderParam(value="Accept") String var40, Context var41);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> createNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="resource") PathResourceType var7, @QueryParam(value="continuation") String var8, @QueryParam(value="mode") PathRenameMode var9, @HeaderParam(value="x-ms-cache-control") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-content-type") String var14, @HeaderParam(value="x-ms-rename-source") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-source-lease-id") String var17, @HeaderParam(value="x-ms-properties") String var18, @HeaderParam(value="x-ms-permissions") String var19, @HeaderParam(value="x-ms-umask") String var20, @HeaderParam(value="If-Match") String var21, @HeaderParam(value="If-None-Match") String var22, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var24, @HeaderParam(value="x-ms-source-if-match") String var25, @HeaderParam(value="x-ms-source-if-none-match") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-encryption-key") String var29, @HeaderParam(value="x-ms-encryption-key-sha256") String var30, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var31, @HeaderParam(value="x-ms-owner") String var32, @HeaderParam(value="x-ms-group") String var33, @HeaderParam(value="x-ms-acl") String var34, @HeaderParam(value="x-ms-proposed-lease-id") String var35, @HeaderParam(value="x-ms-lease-duration") Long var36, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var37, @HeaderParam(value="x-ms-expiry-time") String var38, @HeaderParam(value="x-ms-encryption-context") String var39, @HeaderParam(value="Accept") String var40, Context var41);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse>> update(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathUpdateAction var7, @QueryParam(value="maxRecords") Integer var8, @QueryParam(value="continuation") String var9, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var10, @QueryParam(value="forceFlag") Boolean var11, @QueryParam(value="position") Long var12, @QueryParam(value="retainUncommittedData") Boolean var13, @QueryParam(value="close") Boolean var14, @HeaderParam(value="Content-Length") Long var15, @HeaderParam(value="x-ms-content-md5") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-cache-control") String var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-content-disposition") String var20, @HeaderParam(value="x-ms-content-encoding") String var21, @HeaderParam(value="x-ms-content-language") String var22, @HeaderParam(value="x-ms-properties") String var23, @HeaderParam(value="x-ms-owner") String var24, @HeaderParam(value="x-ms-group") String var25, @HeaderParam(value="x-ms-permissions") String var26, @HeaderParam(value="x-ms-acl") String var27, @HeaderParam(value="If-Match") String var28, @HeaderParam(value="If-None-Match") String var29, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var30, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var31, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<SetAccessControlRecursiveResponse>> updateNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathUpdateAction var7, @QueryParam(value="maxRecords") Integer var8, @QueryParam(value="continuation") String var9, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var10, @QueryParam(value="forceFlag") Boolean var11, @QueryParam(value="position") Long var12, @QueryParam(value="retainUncommittedData") Boolean var13, @QueryParam(value="close") Boolean var14, @HeaderParam(value="Content-Length") Long var15, @HeaderParam(value="x-ms-content-md5") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-cache-control") String var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-content-disposition") String var20, @HeaderParam(value="x-ms-content-encoding") String var21, @HeaderParam(value="x-ms-content-language") String var22, @HeaderParam(value="x-ms-properties") String var23, @HeaderParam(value="x-ms-owner") String var24, @HeaderParam(value="x-ms-group") String var25, @HeaderParam(value="x-ms-permissions") String var26, @HeaderParam(value="x-ms-acl") String var27, @HeaderParam(value="If-Match") String var28, @HeaderParam(value="If-None-Match") String var29, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var30, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var31, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse>> update(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathUpdateAction var7, @QueryParam(value="maxRecords") Integer var8, @QueryParam(value="continuation") String var9, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var10, @QueryParam(value="forceFlag") Boolean var11, @QueryParam(value="position") Long var12, @QueryParam(value="retainUncommittedData") Boolean var13, @QueryParam(value="close") Boolean var14, @HeaderParam(value="Content-Length") Long var15, @HeaderParam(value="x-ms-content-md5") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-cache-control") String var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-content-disposition") String var20, @HeaderParam(value="x-ms-content-encoding") String var21, @HeaderParam(value="x-ms-content-language") String var22, @HeaderParam(value="x-ms-properties") String var23, @HeaderParam(value="x-ms-owner") String var24, @HeaderParam(value="x-ms-group") String var25, @HeaderParam(value="x-ms-permissions") String var26, @HeaderParam(value="x-ms-acl") String var27, @HeaderParam(value="If-Match") String var28, @HeaderParam(value="If-None-Match") String var29, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var30, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var31, @BodyParam(value="application/octet-stream") BinaryData var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<SetAccessControlRecursiveResponse>> updateNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathUpdateAction var7, @QueryParam(value="maxRecords") Integer var8, @QueryParam(value="continuation") String var9, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var10, @QueryParam(value="forceFlag") Boolean var11, @QueryParam(value="position") Long var12, @QueryParam(value="retainUncommittedData") Boolean var13, @QueryParam(value="close") Boolean var14, @HeaderParam(value="Content-Length") Long var15, @HeaderParam(value="x-ms-content-md5") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-cache-control") String var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-content-disposition") String var20, @HeaderParam(value="x-ms-content-encoding") String var21, @HeaderParam(value="x-ms-content-language") String var22, @HeaderParam(value="x-ms-properties") String var23, @HeaderParam(value="x-ms-owner") String var24, @HeaderParam(value="x-ms-group") String var25, @HeaderParam(value="x-ms-permissions") String var26, @HeaderParam(value="x-ms-acl") String var27, @HeaderParam(value="If-Match") String var28, @HeaderParam(value="If-None-Match") String var29, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var30, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var31, @BodyParam(value="application/octet-stream") BinaryData var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsUpdateHeaders, SetAccessControlRecursiveResponse> updateSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathUpdateAction var7, @QueryParam(value="maxRecords") Integer var8, @QueryParam(value="continuation") String var9, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var10, @QueryParam(value="forceFlag") Boolean var11, @QueryParam(value="position") Long var12, @QueryParam(value="retainUncommittedData") Boolean var13, @QueryParam(value="close") Boolean var14, @HeaderParam(value="Content-Length") Long var15, @HeaderParam(value="x-ms-content-md5") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-cache-control") String var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-content-disposition") String var20, @HeaderParam(value="x-ms-content-encoding") String var21, @HeaderParam(value="x-ms-content-language") String var22, @HeaderParam(value="x-ms-properties") String var23, @HeaderParam(value="x-ms-owner") String var24, @HeaderParam(value="x-ms-group") String var25, @HeaderParam(value="x-ms-permissions") String var26, @HeaderParam(value="x-ms-acl") String var27, @HeaderParam(value="If-Match") String var28, @HeaderParam(value="If-None-Match") String var29, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var30, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var31, @BodyParam(value="application/octet-stream") BinaryData var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<SetAccessControlRecursiveResponse> updateNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathUpdateAction var7, @QueryParam(value="maxRecords") Integer var8, @QueryParam(value="continuation") String var9, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var10, @QueryParam(value="forceFlag") Boolean var11, @QueryParam(value="position") Long var12, @QueryParam(value="retainUncommittedData") Boolean var13, @QueryParam(value="close") Boolean var14, @HeaderParam(value="Content-Length") Long var15, @HeaderParam(value="x-ms-content-md5") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-cache-control") String var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-content-disposition") String var20, @HeaderParam(value="x-ms-content-encoding") String var21, @HeaderParam(value="x-ms-content-language") String var22, @HeaderParam(value="x-ms-properties") String var23, @HeaderParam(value="x-ms-owner") String var24, @HeaderParam(value="x-ms-group") String var25, @HeaderParam(value="x-ms-permissions") String var26, @HeaderParam(value="x-ms-acl") String var27, @HeaderParam(value="If-Match") String var28, @HeaderParam(value="If-None-Match") String var29, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var30, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var31, @BodyParam(value="application/octet-stream") BinaryData var32, @HeaderParam(value="Accept") String var33, Context var34);

        @Post(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsLeaseHeaders, Void>> lease(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-action") PathLeaseAction var7, @HeaderParam(value="x-ms-lease-duration") Integer var8, @HeaderParam(value="x-ms-lease-break-period") Integer var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-proposed-lease-id") String var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Post(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> leaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-action") PathLeaseAction var7, @HeaderParam(value="x-ms-lease-duration") Integer var8, @HeaderParam(value="x-ms-lease-break-period") Integer var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-proposed-lease-id") String var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Post(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsLeaseHeaders, Void> leaseSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-action") PathLeaseAction var7, @HeaderParam(value="x-ms-lease-duration") Integer var8, @HeaderParam(value="x-ms-lease-break-period") Integer var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-proposed-lease-id") String var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Post(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> leaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-action") PathLeaseAction var7, @HeaderParam(value="x-ms-lease-duration") Integer var8, @HeaderParam(value="x-ms-lease-break-period") Integer var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-proposed-lease-id") String var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Get(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsReadHeaders, Flux<ByteBuffer>>> read(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="x-ms-encryption-key") String var14, @HeaderParam(value="x-ms-encryption-key-sha256") String var15, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Get(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<StreamResponse> readNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="x-ms-encryption-key") String var14, @HeaderParam(value="x-ms-encryption-key-sha256") String var15, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Get(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsReadHeaders, InputStream> readSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="x-ms-encryption-key") String var14, @HeaderParam(value="x-ms-encryption-key-sha256") String var15, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Get(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<InputStream> readNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="x-ms-encryption-key") String var14, @HeaderParam(value="x-ms-encryption-key-sha256") String var15, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Head(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathGetPropertiesAction var7, @QueryParam(value="upn") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Head(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathGetPropertiesAction var7, @QueryParam(value="upn") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Head(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsGetPropertiesHeaders, Void> getPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathGetPropertiesAction var7, @QueryParam(value="upn") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Head(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="action") PathGetPropertiesAction var7, @QueryParam(value="upn") Boolean var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Delete(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="recursive") Boolean var7, @QueryParam(value="continuation") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @QueryParam(value="paginated") Boolean var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Delete(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="recursive") Boolean var7, @QueryParam(value="continuation") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @QueryParam(value="paginated") Boolean var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Delete(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsDeleteHeaders, Void> deleteSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="recursive") Boolean var7, @QueryParam(value="continuation") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @QueryParam(value="paginated") Boolean var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Delete(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> deleteNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="recursive") Boolean var7, @QueryParam(value="continuation") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @QueryParam(value="paginated") Boolean var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsSetAccessControlHeaders, Void>> setAccessControl(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-owner") String var7, @HeaderParam(value="x-ms-group") String var8, @HeaderParam(value="x-ms-permissions") String var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> setAccessControlNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-owner") String var7, @HeaderParam(value="x-ms-group") String var8, @HeaderParam(value="x-ms-permissions") String var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsSetAccessControlHeaders, Void> setAccessControlSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-owner") String var7, @HeaderParam(value="x-ms-group") String var8, @HeaderParam(value="x-ms-permissions") String var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> setAccessControlNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-owner") String var7, @HeaderParam(value="x-ms-group") String var8, @HeaderParam(value="x-ms-permissions") String var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse>> setAccessControlRecursive(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="continuation") String var6, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var7, @QueryParam(value="forceFlag") Boolean var8, @QueryParam(value="maxRecords") Integer var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<SetAccessControlRecursiveResponse>> setAccessControlRecursiveNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="continuation") String var6, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var7, @QueryParam(value="forceFlag") Boolean var8, @QueryParam(value="maxRecords") Integer var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse> setAccessControlRecursiveSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="continuation") String var6, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var7, @QueryParam(value="forceFlag") Boolean var8, @QueryParam(value="maxRecords") Integer var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<SetAccessControlRecursiveResponse> setAccessControlRecursiveNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="continuation") String var6, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var7, @QueryParam(value="forceFlag") Boolean var8, @QueryParam(value="maxRecords") Integer var9, @HeaderParam(value="x-ms-acl") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsFlushDataHeaders, Void>> flushData(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="position") Long var6, @QueryParam(value="retainUncommittedData") Boolean var7, @QueryParam(value="close") Boolean var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="x-ms-content-md5") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-lease-action") LeaseAction var12, @HeaderParam(value="x-ms-lease-duration") Long var13, @HeaderParam(value="x-ms-proposed-lease-id") String var14, @HeaderParam(value="x-ms-cache-control") String var15, @HeaderParam(value="x-ms-content-type") String var16, @HeaderParam(value="x-ms-content-disposition") String var17, @HeaderParam(value="x-ms-content-encoding") String var18, @HeaderParam(value="x-ms-content-language") String var19, @HeaderParam(value="If-Match") String var20, @HeaderParam(value="If-None-Match") String var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="x-ms-client-request-id") String var24, @HeaderParam(value="x-ms-version") String var25, @HeaderParam(value="x-ms-encryption-key") String var26, @HeaderParam(value="x-ms-encryption-key-sha256") String var27, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var28, @HeaderParam(value="Accept") String var29, Context var30);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> flushDataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="position") Long var6, @QueryParam(value="retainUncommittedData") Boolean var7, @QueryParam(value="close") Boolean var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="x-ms-content-md5") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-lease-action") LeaseAction var12, @HeaderParam(value="x-ms-lease-duration") Long var13, @HeaderParam(value="x-ms-proposed-lease-id") String var14, @HeaderParam(value="x-ms-cache-control") String var15, @HeaderParam(value="x-ms-content-type") String var16, @HeaderParam(value="x-ms-content-disposition") String var17, @HeaderParam(value="x-ms-content-encoding") String var18, @HeaderParam(value="x-ms-content-language") String var19, @HeaderParam(value="If-Match") String var20, @HeaderParam(value="If-None-Match") String var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="x-ms-client-request-id") String var24, @HeaderParam(value="x-ms-version") String var25, @HeaderParam(value="x-ms-encryption-key") String var26, @HeaderParam(value="x-ms-encryption-key-sha256") String var27, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var28, @HeaderParam(value="Accept") String var29, Context var30);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsFlushDataHeaders, Void> flushDataSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="position") Long var6, @QueryParam(value="retainUncommittedData") Boolean var7, @QueryParam(value="close") Boolean var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="x-ms-content-md5") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-lease-action") LeaseAction var12, @HeaderParam(value="x-ms-lease-duration") Long var13, @HeaderParam(value="x-ms-proposed-lease-id") String var14, @HeaderParam(value="x-ms-cache-control") String var15, @HeaderParam(value="x-ms-content-type") String var16, @HeaderParam(value="x-ms-content-disposition") String var17, @HeaderParam(value="x-ms-content-encoding") String var18, @HeaderParam(value="x-ms-content-language") String var19, @HeaderParam(value="If-Match") String var20, @HeaderParam(value="If-None-Match") String var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="x-ms-client-request-id") String var24, @HeaderParam(value="x-ms-version") String var25, @HeaderParam(value="x-ms-encryption-key") String var26, @HeaderParam(value="x-ms-encryption-key-sha256") String var27, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var28, @HeaderParam(value="Accept") String var29, Context var30);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> flushDataNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="position") Long var6, @QueryParam(value="retainUncommittedData") Boolean var7, @QueryParam(value="close") Boolean var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="x-ms-content-md5") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-lease-action") LeaseAction var12, @HeaderParam(value="x-ms-lease-duration") Long var13, @HeaderParam(value="x-ms-proposed-lease-id") String var14, @HeaderParam(value="x-ms-cache-control") String var15, @HeaderParam(value="x-ms-content-type") String var16, @HeaderParam(value="x-ms-content-disposition") String var17, @HeaderParam(value="x-ms-content-encoding") String var18, @HeaderParam(value="x-ms-content-language") String var19, @HeaderParam(value="If-Match") String var20, @HeaderParam(value="If-None-Match") String var21, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var23, @HeaderParam(value="x-ms-client-request-id") String var24, @HeaderParam(value="x-ms-version") String var25, @HeaderParam(value="x-ms-encryption-key") String var26, @HeaderParam(value="x-ms-encryption-key-sha256") String var27, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var28, @HeaderParam(value="Accept") String var29, Context var30);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsAppendDataHeaders, Void>> appendData(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="position") Long var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-lease-action") LeaseAction var11, @HeaderParam(value="x-ms-lease-duration") Long var12, @HeaderParam(value="x-ms-proposed-lease-id") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @QueryParam(value="flush") Boolean var19, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> appendDataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="position") Long var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-lease-action") LeaseAction var11, @HeaderParam(value="x-ms-lease-duration") Long var12, @HeaderParam(value="x-ms-proposed-lease-id") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @QueryParam(value="flush") Boolean var19, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsAppendDataHeaders, Void>> appendData(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="position") Long var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-lease-action") LeaseAction var11, @HeaderParam(value="x-ms-lease-duration") Long var12, @HeaderParam(value="x-ms-proposed-lease-id") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @QueryParam(value="flush") Boolean var19, @BodyParam(value="application/octet-stream") BinaryData var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> appendDataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="position") Long var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-lease-action") LeaseAction var11, @HeaderParam(value="x-ms-lease-duration") Long var12, @HeaderParam(value="x-ms-proposed-lease-id") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @QueryParam(value="flush") Boolean var19, @BodyParam(value="application/octet-stream") BinaryData var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsAppendDataHeaders, Void> appendDataSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="position") Long var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-lease-action") LeaseAction var11, @HeaderParam(value="x-ms-lease-duration") Long var12, @HeaderParam(value="x-ms-proposed-lease-id") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @QueryParam(value="flush") Boolean var19, @BodyParam(value="application/octet-stream") BinaryData var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Patch(value="/{filesystem}/{path}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> appendDataNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="action") String var4, @QueryParam(value="position") Long var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-lease-action") LeaseAction var11, @HeaderParam(value="x-ms-lease-duration") Long var12, @HeaderParam(value="x-ms-proposed-lease-id") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @QueryParam(value="flush") Boolean var19, @BodyParam(value="application/octet-stream") BinaryData var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsSetExpiryHeaders, Void>> setExpiry(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var8, @HeaderParam(value="x-ms-expiry-time") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> setExpiryNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var8, @HeaderParam(value="x-ms-expiry-time") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsSetExpiryHeaders, Void> setExpirySync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var8, @HeaderParam(value="x-ms-expiry-time") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> setExpiryNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var8, @HeaderParam(value="x-ms-expiry-time") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ResponseBase<PathsUndeleteHeaders, Void>> undelete(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-undelete-source") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<Response<Void>> undeleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-undelete-source") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public ResponseBase<PathsUndeleteHeaders, Void> undeleteSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-undelete-source") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Response<Void> undeleteNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @PathParam(value="path") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-undelete-source") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

