/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.azure.storage.datalake.DataLakeUtils;

public final class FileStreamAndLength {
    private final InputStream inputStream;
    private final long streamLength;

    private FileStreamAndLength(InputStream inputStream, long streamLength) {
        this.inputStream = inputStream;
        this.streamLength = streamLength;
    }

    public static FileStreamAndLength createFileStreamAndLengthFromExchangeBody(Exchange exchange) throws IOException {
        Object body = exchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof InputStream) {
            if (!((InputStream)body).markSupported()) {
                throw new IllegalArgumentException("Inputstream does not support mark rest operations");
            }
            return new FileStreamAndLength((InputStream)body, DataLakeUtils.getInputStreamLength((InputStream)body));
        }
        if (body instanceof File) {
            return new FileStreamAndLength(new BufferedInputStream(new FileInputStream((File)body)), ((File)body).length());
        }
        if (body instanceof byte[]) {
            return new FileStreamAndLength(new ByteArrayInputStream((byte[])body), ((byte[])body).length);
        }
        InputStream inputStream = exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, exchange, body);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unsupported file type");
        }
        return new FileStreamAndLength(inputStream, DataLakeUtils.getInputStreamLength(inputStream));
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getStreamLength() {
        return this.streamLength;
    }
}

