/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobAudience;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.Utility;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeAudience;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeFileClient.class, DataLakeFileAsyncClient.class, DataLakeDirectoryClient.class, DataLakeDirectoryAsyncClient.class})
public final class DataLakePathClientBuilder
implements TokenCredentialTrait<DataLakePathClientBuilder>,
AzureNamedKeyCredentialTrait<DataLakePathClientBuilder>,
AzureSasCredentialTrait<DataLakePathClientBuilder>,
HttpTrait<DataLakePathClientBuilder>,
ConfigurationTrait<DataLakePathClientBuilder>,
EndpointTrait<DataLakePathClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakePathClientBuilder.class);
    private final BlobClientBuilder blobClientBuilder;
    private String endpoint;
    private String accountName;
    private String fileSystemName;
    private String pathName;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private DataLakeServiceVersion version;
    private CpkInfo customerProvidedKey;
    private DataLakeAudience audience;

    public DataLakePathClientBuilder() {
        this.logOptions = DataLakePathClientBuilder.getDefaultHttpLogOptions();
        this.blobClientBuilder = new BlobClientBuilder();
        this.blobClientBuilder.addPolicy(BuilderHelper.getBlobUserAgentModificationPolicy());
    }

    private DataLakeServiceVersion getServiceVersion() {
        return this.version != null ? this.version : DataLakeServiceVersion.getLatest();
    }

    private HttpPipeline constructPipeline() {
        return this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.audience, LOGGER);
    }

    public DataLakeFileClient buildFileClient() {
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty(this.fileSystemName) ? "$root" : this.fileSystemName;
        DataLakeFileAsyncClient fileAsyncClient = this.buildFileAsyncClient();
        return new DataLakeFileClient(fileAsyncClient, this.blobClientBuilder.buildClient().getBlockBlobClient(), fileAsyncClient.getHttpPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, dataLakeFileSystemName, this.pathName, this.azureSasCredential, this.customerProvidedKey, this.tokenCredential != null);
    }

    public DataLakeFileAsyncClient buildFileAsyncClient() {
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty(this.fileSystemName) ? "$root" : this.fileSystemName;
        return new DataLakeFileAsyncClient(this.constructPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, dataLakeFileSystemName, this.pathName, this.blobClientBuilder.buildAsyncClient().getBlockBlobAsyncClient(), this.azureSasCredential, this.customerProvidedKey, this.tokenCredential != null);
    }

    public DataLakeDirectoryClient buildDirectoryClient() {
        this.validateConstruction();
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty(this.fileSystemName) ? "$root" : this.fileSystemName;
        DataLakeDirectoryAsyncClient directoryAsyncClient = this.buildDirectoryAsyncClient();
        return new DataLakeDirectoryClient(directoryAsyncClient, this.blobClientBuilder.buildClient().getBlockBlobClient(), directoryAsyncClient.getHttpPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, dataLakeFileSystemName, this.pathName, this.azureSasCredential, this.customerProvidedKey, this.tokenCredential != null);
    }

    public DataLakeDirectoryAsyncClient buildDirectoryAsyncClient() {
        this.validateConstruction();
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty(this.fileSystemName) ? "$root" : this.fileSystemName;
        return new DataLakeDirectoryAsyncClient(this.constructPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, dataLakeFileSystemName, this.pathName, this.blobClientBuilder.buildAsyncClient().getBlockBlobAsyncClient(), this.azureSasCredential, this.customerProvidedKey, this.tokenCredential != null);
    }

    private void validateConstruction() {
        Objects.requireNonNull(this.pathName, "'pathName' cannot be null.");
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null");
        BuilderHelper.httpsValidation(this.customerProvidedKey, "customer provided key", this.endpoint, LOGGER);
    }

    public DataLakePathClientBuilder credential(StorageSharedKeyCredential credential) {
        this.blobClientBuilder.credential(credential);
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    @Override
    public DataLakePathClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential(credential));
    }

    @Override
    public DataLakePathClientBuilder credential(TokenCredential credential) {
        this.blobClientBuilder.credential(credential);
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    public DataLakePathClientBuilder sasToken(String sasToken) {
        this.blobClientBuilder.sasToken(sasToken);
        this.azureSasCredential = new AzureSasCredential(Objects.requireNonNull(sasToken, "'sasToken' cannot be null."));
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    @Override
    public DataLakePathClientBuilder credential(AzureSasCredential credential) {
        this.blobClientBuilder.credential(credential);
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public DataLakePathClientBuilder setAnonymousAccess() {
        this.blobClientBuilder.setAnonymousAccess();
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    @Override
    public DataLakePathClientBuilder endpoint(String endpoint) {
        endpoint = DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "dfs", "blob");
        this.blobClientBuilder.endpoint(DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "blob", "dfs"));
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse(url);
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            this.fileSystemName = parts.getBlobContainerName() == null ? this.fileSystemName : parts.getBlobContainerName();
            this.pathName = parts.getBlobName() == null ? this.pathName : Utility.urlEncode(parts.getBlobName());
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty(sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Azure Storage DataLake endpoint url is malformed.", ex));
        }
        return this;
    }

    public DataLakePathClientBuilder fileSystemName(String fileSystemName) {
        this.blobClientBuilder.containerName(fileSystemName);
        this.fileSystemName = fileSystemName;
        return this;
    }

    public DataLakePathClientBuilder pathName(String pathName) {
        this.blobClientBuilder.blobName(pathName);
        this.pathName = Utility.urlEncode(Utility.urlDecode(Objects.requireNonNull(pathName, "'pathName' cannot be null.")));
        return this;
    }

    @Override
    public DataLakePathClientBuilder httpClient(HttpClient httpClient) {
        this.blobClientBuilder.httpClient(httpClient);
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    @Override
    public DataLakePathClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.blobClientBuilder.addPolicy(pipelinePolicy);
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    @Override
    public DataLakePathClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.blobClientBuilder.httpLogOptions(logOptions);
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    @Override
    public DataLakePathClientBuilder configuration(Configuration configuration) {
        this.blobClientBuilder.configuration(configuration);
        this.configuration = configuration;
        return this;
    }

    public DataLakePathClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.blobClientBuilder.retryOptions(retryOptions);
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public DataLakePathClientBuilder retryOptions(RetryOptions retryOptions) {
        this.blobClientBuilder.retryOptions(retryOptions);
        this.coreRetryOptions = retryOptions;
        return this;
    }

    @Override
    public DataLakePathClientBuilder clientOptions(ClientOptions clientOptions) {
        this.blobClientBuilder.clientOptions(clientOptions);
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    @Override
    public DataLakePathClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.blobClientBuilder.pipeline(httpPipeline);
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public DataLakePathClientBuilder serviceVersion(DataLakeServiceVersion version) {
        this.blobClientBuilder.serviceVersion(TransformUtils.toBlobServiceVersion(version));
        this.version = version;
        return this;
    }

    public DataLakePathClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        if (customerProvidedKey == null) {
            this.blobClientBuilder.customerProvidedKey(null);
            this.customerProvidedKey = null;
        } else {
            this.blobClientBuilder.customerProvidedKey(Transforms.toBlobCustomerProvidedKey(customerProvidedKey));
            this.customerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return this;
    }

    public DataLakePathClientBuilder audience(DataLakeAudience audience) {
        this.audience = audience;
        if (audience != null) {
            this.blobClientBuilder.audience(BlobAudience.fromString(audience.toString()));
        }
        return this;
    }
}

