/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeConstants;
import org.apache.camel.component.azure.storage.datalake.DataLakeConsumer;
import org.apache.camel.component.azure.storage.datalake.DataLakeProducer;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeClientFactory;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeOperationResponse;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.8.0", scheme="azure-storage-datalake", title="Azure Storage Data Lake Service", syntax="azure-storage-datalake:accountName/fileSystemName", category={Category.CLOUD, Category.FILE, Category.BIGDATA}, headersClass=DataLakeConstants.class)
public class DataLakeEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    @UriParam(description="service client of data lake")
    private DataLakeServiceClient dataLakeServiceClient;
    @UriParam(description="configuration object of azure data lake")
    private DataLakeConfiguration configuration;

    public DataLakeEndpoint() {
    }

    public DataLakeEndpoint(String uri, Component component, DataLakeConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DataLakeProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        DataLakeConsumer consumer = new DataLakeConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public DataLakeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DataLakeConfiguration configuration) {
        this.configuration = configuration;
    }

    public DataLakeServiceClient getDataLakeServiceClient() {
        return this.dataLakeServiceClient;
    }

    public void setDataLakeServiceClient(DataLakeServiceClient dataLakeServiceClient) {
        this.dataLakeServiceClient = dataLakeServiceClient;
    }

    public void setResponseOnExchange(DataLakeOperationResponse response, Exchange exchange) {
        Message message = exchange.getIn();
        message.setBody(response.getBody());
        message.setHeaders(response.getHeaders());
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.dataLakeServiceClient = this.configuration.getServiceClient() != null ? this.configuration.getServiceClient() : DataLakeClientFactory.createDataLakeServiceClient(this.configuration);
    }

    @Override
    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty(this.configuration.getFileSystemName())) {
            return this.configuration.getFileSystemName();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "datalake";
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (ObjectHelper.isNotEmpty(this.configuration.getAccountName())) {
            return Map.of("account", this.configuration.getAccountName());
        }
        return null;
    }
}

