/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.client;

import com.azure.core.credential.AzureSasCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import java.util.Locale;
import org.apache.camel.component.azure.storage.datalake.CredentialType;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataLakeClientFactory {
    private static final String SERVICE_URI_SEGMENT = ".dfs.core.windows.net";
    private static final Logger LOG = LoggerFactory.getLogger(DataLakeClientFactory.class);

    private DataLakeClientFactory() {
    }

    public static DataLakeServiceClient createDataLakeServiceClient(DataLakeConfiguration configuration) {
        DataLakeServiceClient client = null;
        if (configuration.getServiceClient() != null && configuration.getCredentialType().equals((Object)CredentialType.SERVICE_CLIENT_INSTANCE)) {
            LOG.trace("Using configured service client instance");
            client = configuration.getServiceClient();
        } else if (configuration.getCredentialType().equals((Object)CredentialType.AZURE_IDENTITY)) {
            client = DataLakeClientFactory.createDataLakeServiceClientWithDefaultIdentity(configuration);
        } else if (configuration.getCredentialType().equals((Object)CredentialType.SHARED_KEY_CREDENTIAL)) {
            if (configuration.getAccountKey() != null || configuration.getSharedKeyCredential() != null) {
                client = DataLakeClientFactory.createDataLakeServiceClientWithSharedKey(configuration);
            }
        } else if (configuration.getCredentialType().equals((Object)CredentialType.AZURE_SAS)) {
            if (configuration.getSasSignature() != null || configuration.getSasCredential() != null) {
                client = DataLakeClientFactory.createDataLakeServiceClientWithSas(configuration);
            }
        } else if (configuration.getCredentialType().equals((Object)CredentialType.CLIENT_SECRET)) {
            client = DataLakeClientFactory.createDataLakeServiceClientWithClientSecret(configuration);
        }
        return client;
    }

    private static DataLakeServiceClient createDataLakeServiceClientWithSharedKey(DataLakeConfiguration configuration) {
        StorageSharedKeyCredential sharedKeyCredential = configuration.getSharedKeyCredential();
        if (sharedKeyCredential == null) {
            LOG.trace("Using account name and account key to instantiate service client");
            sharedKeyCredential = new StorageSharedKeyCredential(configuration.getAccountName(), configuration.getAccountKey());
        } else {
            LOG.trace("Using configured shared key instance to instantiate service client");
        }
        return new DataLakeServiceClientBuilder().credential(sharedKeyCredential).endpoint(DataLakeClientFactory.buildAzureUri(configuration)).buildClient();
    }

    private static DataLakeServiceClient createDataLakeServiceClientWithClientSecret(DataLakeConfiguration configuration) {
        ClientSecretCredential clientSecretCredential = configuration.getClientSecretCredential();
        if (clientSecretCredential == null) {
            LOG.trace("Using client id, client secret, tenant id to instantiate service client");
            clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(configuration.getClientId())).clientSecret(configuration.getClientSecret()).tenantId(configuration.getTenantId())).build();
        } else {
            LOG.trace("Using configured client secret instance to instantiate service client");
        }
        return new DataLakeServiceClientBuilder().credential(clientSecretCredential).endpoint(DataLakeClientFactory.buildAzureUri(configuration)).buildClient();
    }

    private static DataLakeServiceClient createDataLakeServiceClientWithSas(DataLakeConfiguration configuration) {
        AzureSasCredential sasCredential = configuration.getSasCredential();
        if (sasCredential == null) {
            LOG.trace("Using SAS signature to instantiate service client");
            sasCredential = new AzureSasCredential(configuration.getSasSignature());
        } else {
            LOG.trace("Using configured SAS instance to instantiate service client");
        }
        return new DataLakeServiceClientBuilder().credential(sasCredential).endpoint(DataLakeClientFactory.buildAzureUri(configuration)).buildClient();
    }

    private static DataLakeServiceClient createDataLakeServiceClientWithDefaultIdentity(DataLakeConfiguration configuration) {
        LOG.trace("Using default identity to instantiate service client");
        DefaultAzureCredentialBuilder defaultAzureCredentialBuilder = new DefaultAzureCredentialBuilder();
        if (configuration.getTenantId() != null) {
            defaultAzureCredentialBuilder.tenantId(configuration.getTenantId());
        }
        return new DataLakeServiceClientBuilder().credential(defaultAzureCredentialBuilder.build()).endpoint(DataLakeClientFactory.buildAzureUri(configuration)).buildClient();
    }

    private static String buildAzureUri(DataLakeConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.dfs.core.windows.net", DataLakeClientFactory.getAccountName(configuration));
    }

    private static String getAccountName(DataLakeConfiguration configuration) {
        String accountName = ObjectHelper.isNotEmpty(configuration.getSharedKeyCredential()) ? configuration.getSharedKeyCredential().getAccountName() : configuration.getAccountName();
        return accountName;
    }
}

