/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.ListQueuesSegmentResponse;
import com.azure.storage.queue.implementation.models.ServicesGetPropertiesHeaders;
import com.azure.storage.queue.implementation.models.ServicesGetStatisticsHeaders;
import com.azure.storage.queue.implementation.models.ServicesListQueuesSegmentHeaders;
import com.azure.storage.queue.implementation.models.ServicesListQueuesSegmentNextHeaders;
import com.azure.storage.queue.implementation.models.ServicesSetPropertiesHeaders;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueueServiceProperties;
import com.azure.storage.queue.models.QueueServiceStatistics;
import com.azure.storage.queue.models.QueueStorageException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureQueueStorageImpl client;

    ServicesImpl(AzureQueueStorageImpl client) {
        this.service = RestProxy.create(ServicesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId) {
        return this.setPropertiesWithResponseAsync(queueServiceProperties, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId, Context context) {
        return this.setPropertiesWithResponseAsync(queueServiceProperties, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesWithResponse(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId) {
        this.setPropertiesWithResponse(queueServiceProperties, timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceProperties> getPropertiesAsync(Integer timeout, String requestId) {
        return this.getPropertiesWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((QueueServiceProperties)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceProperties> getPropertiesAsync(Integer timeout, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((QueueServiceProperties)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties> getPropertiesWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueServiceProperties getProperties(Integer timeout, String requestId) {
        return this.getPropertiesWithResponse(timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueServiceProperties> getPropertiesNoCustomHeadersWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceStatistics> getStatisticsAsync(Integer timeout, String requestId) {
        return this.getStatisticsWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((QueueServiceStatistics)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceStatistics> getStatisticsAsync(Integer timeout, String requestId, Context context) {
        return this.getStatisticsWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((QueueServiceStatistics)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getStatisticsNoCustomHeaders(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueServiceStatistics>> getStatisticsNoCustomHeadersWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsNoCustomHeaders(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics> getStatisticsWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsSync(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueServiceStatistics getStatistics(Integer timeout, String requestId) {
        return this.getStatisticsWithResponse(timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueServiceStatistics> getStatisticsNoCustomHeadersWithResponse(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsNoCustomHeadersSync(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listQueuesSegment(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase<ServicesListQueuesSegmentHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (ServicesListQueuesSegmentHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listQueuesSegment(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase<ServicesListQueuesSegmentHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (ServicesListQueuesSegmentHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueuesSegmentAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        return new PagedFlux<QueueItem>(() -> this.listQueuesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout, requestId), nextLink -> this.listQueuesSegmentNextSinglePageAsync((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueuesSegmentAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        return new PagedFlux<QueueItem>(() -> this.listQueuesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout, requestId, context), nextLink -> this.listQueuesSegmentNextSinglePageAsync((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listQueuesSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNoCustomHeadersSinglePageAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listQueuesSegmentNoCustomHeaders(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueuesSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        return new PagedFlux<QueueItem>(() -> this.listQueuesSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, include, timeout, requestId), nextLink -> this.listQueuesSegmentNextSinglePageAsync((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueuesSegmentNoCustomHeadersAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        return new PagedFlux<QueueItem>(() -> this.listQueuesSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, include, timeout, requestId, context), nextLink -> this.listQueuesSegmentNextSinglePageAsync((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentSinglePage(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        ResponseBase<ServicesListQueuesSegmentHeaders, ListQueuesSegmentResponse> res = this.service.listQueuesSegmentSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", Context.NONE);
        return new PagedResponseBase<ServicesListQueuesSegmentHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentSinglePage(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        ResponseBase<ServicesListQueuesSegmentHeaders, ListQueuesSegmentResponse> res = this.service.listQueuesSegmentSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
        return new PagedResponseBase<ServicesListQueuesSegmentHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueuesSegment(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        return new PagedIterable<QueueItem>(() -> this.listQueuesSegmentSinglePage(prefix, marker, maxresults, include, timeout, requestId, Context.NONE), nextLink -> this.listQueuesSegmentNextSinglePage((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueuesSegment(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        return new PagedIterable<QueueItem>(() -> this.listQueuesSegmentSinglePage(prefix, marker, maxresults, include, timeout, requestId, context), nextLink -> this.listQueuesSegmentNextSinglePage((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentNoCustomHeadersSinglePage(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        Response<ListQueuesSegmentResponse> res = this.service.listQueuesSegmentNoCustomHeadersSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", Context.NONE);
        return new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentNoCustomHeadersSinglePage(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        Response<ListQueuesSegmentResponse> res = this.service.listQueuesSegmentNoCustomHeadersSync(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
        return new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueuesSegmentNoCustomHeaders(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        return new PagedIterable<QueueItem>(() -> this.listQueuesSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, include, timeout, requestId, Context.NONE), nextLink -> this.listQueuesSegmentNextSinglePage((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueItem> listQueuesSegmentNoCustomHeaders(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        return new PagedIterable<QueueItem>(() -> this.listQueuesSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, include, timeout, requestId, context), nextLink -> this.listQueuesSegmentNextSinglePage((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNextSinglePageAsync(String nextLink, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listQueuesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase<ServicesListQueuesSegmentNextHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (ServicesListQueuesSegmentNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNextSinglePageAsync(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.listQueuesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase<ServicesListQueuesSegmentNextHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (ServicesListQueuesSegmentNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNextNoCustomHeadersSinglePageAsync(String nextLink, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listQueuesSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNextNoCustomHeadersSinglePageAsync(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.listQueuesSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentNextSinglePage(String nextLink, String requestId) {
        String accept = "application/xml";
        ResponseBase<ServicesListQueuesSegmentNextHeaders, ListQueuesSegmentResponse> res = this.service.listQueuesSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", Context.NONE);
        return new PagedResponseBase<ServicesListQueuesSegmentNextHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentNextSinglePage(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        ResponseBase<ServicesListQueuesSegmentNextHeaders, ListQueuesSegmentResponse> res = this.service.listQueuesSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context);
        return new PagedResponseBase<ServicesListQueuesSegmentNextHeaders, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentNextNoCustomHeadersSinglePage(String nextLink, String requestId) {
        String accept = "application/xml";
        Response<ListQueuesSegmentResponse> res = this.service.listQueuesSegmentNextNoCustomHeadersSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", Context.NONE);
        return new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<QueueItem> listQueuesSegmentNextNoCustomHeadersSinglePage(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        Response<ListQueuesSegmentResponse> res = this.service.listQueuesSegmentNextNoCustomHeadersSync(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context);
        return new PagedResponseBase<Object, QueueItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getQueueItems(), res.getValue().getNextMarker(), null);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageSer")
    public static interface ServicesService {
        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<Void> setPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties>> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<QueueServiceProperties>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties> getPropertiesSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<QueueServiceProperties> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics>> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<QueueServiceStatistics>> getStatisticsNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics> getStatisticsSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<QueueServiceStatistics> getStatisticsNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesListQueuesSegmentHeaders, ListQueuesSegmentResponse>> listQueuesSegment(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<ListQueuesSegmentResponse>> listQueuesSegmentNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<ServicesListQueuesSegmentHeaders, ListQueuesSegmentResponse> listQueuesSegmentSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<ListQueuesSegmentResponse> listQueuesSegmentNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesListQueuesSegmentNextHeaders, ListQueuesSegmentResponse>> listQueuesSegmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<Response<ListQueuesSegmentResponse>> listQueuesSegmentNextNoCustomHeaders(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public ResponseBase<ServicesListQueuesSegmentNextHeaders, ListQueuesSegmentResponse> listQueuesSegmentNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Response<ListQueuesSegmentResponse> listQueuesSegmentNextNoCustomHeadersSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

