/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class PeekedMessageItem
implements XmlSerializable<PeekedMessageItem> {
    private String messageId;
    private DateTimeRfc1123 insertionTime;
    private DateTimeRfc1123 expirationTime;
    private long dequeueCount;
    private BinaryData body;

    public String getMessageId() {
        return this.messageId;
    }

    public PeekedMessageItem setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public OffsetDateTime getInsertionTime() {
        if (this.insertionTime == null) {
            return null;
        }
        return this.insertionTime.getDateTime();
    }

    public PeekedMessageItem setInsertionTime(OffsetDateTime insertionTime) {
        this.insertionTime = insertionTime == null ? null : new DateTimeRfc1123(insertionTime);
        return this;
    }

    public OffsetDateTime getExpirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return this.expirationTime.getDateTime();
    }

    public PeekedMessageItem setExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime == null ? null : new DateTimeRfc1123(expirationTime);
        return this;
    }

    public long getDequeueCount() {
        return this.dequeueCount;
    }

    public PeekedMessageItem setDequeueCount(long dequeueCount) {
        this.dequeueCount = dequeueCount;
        return this;
    }

    @Deprecated
    public String getMessageText() {
        return this.body == null ? null : this.body.toString();
    }

    @Deprecated
    public PeekedMessageItem setMessageText(String messageText) {
        this.body = messageText == null ? null : BinaryData.fromString(messageText);
        return this;
    }

    public BinaryData getBody() {
        return this.body;
    }

    public PeekedMessageItem setBody(BinaryData body) {
        this.body = body;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessage" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("MessageId", this.messageId);
        xmlWriter.writeStringElement("InsertionTime", Objects.toString(this.insertionTime, null));
        xmlWriter.writeStringElement("ExpirationTime", Objects.toString(this.expirationTime, null));
        xmlWriter.writeLongElement("DequeueCount", this.dequeueCount);
        return xmlWriter.writeEndElement();
    }

    public static PeekedMessageItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return PeekedMessageItem.fromXml(xmlReader, null);
    }

    public static PeekedMessageItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessage" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PeekedMessageItem deserializedPeekedMessageItem = new PeekedMessageItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("MessageId".equals(elementName.getLocalPart())) {
                    deserializedPeekedMessageItem.messageId = reader.getStringElement();
                    continue;
                }
                if ("InsertionTime".equals(elementName.getLocalPart())) {
                    deserializedPeekedMessageItem.insertionTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("ExpirationTime".equals(elementName.getLocalPart())) {
                    deserializedPeekedMessageItem.expirationTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("DequeueCount".equals(elementName.getLocalPart())) {
                    deserializedPeekedMessageItem.dequeueCount = reader.getLongElement();
                    continue;
                }
                if ("MessageText".equals(elementName.getLocalPart())) {
                    deserializedPeekedMessageItem.setMessageText(reader.getStringElement());
                    continue;
                }
                reader.skipElement();
            }
            return deserializedPeekedMessageItem;
        });
    }
}

