/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.queue.models.QueueAccessPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueSignedIdentifier
implements XmlSerializable<QueueSignedIdentifier> {
    private String id;
    private QueueAccessPolicy accessPolicy;

    public String getId() {
        return this.id;
    }

    public QueueSignedIdentifier setId(String id) {
        this.id = id;
        return this;
    }

    public QueueAccessPolicy getAccessPolicy() {
        return this.accessPolicy;
    }

    public QueueSignedIdentifier setAccessPolicy(QueueAccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifier" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Id", this.id);
        xmlWriter.writeXml(this.accessPolicy, "AccessPolicy");
        return xmlWriter.writeEndElement();
    }

    public static QueueSignedIdentifier fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueSignedIdentifier.fromXml(xmlReader, null);
    }

    public static QueueSignedIdentifier fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifier" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueSignedIdentifier deserializedQueueSignedIdentifier = new QueueSignedIdentifier();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Id".equals(elementName.getLocalPart())) {
                    deserializedQueueSignedIdentifier.id = reader.getStringElement();
                    continue;
                }
                if ("AccessPolicy".equals(elementName.getLocalPart())) {
                    deserializedQueueSignedIdentifier.accessPolicy = QueueAccessPolicy.fromXml(reader, "AccessPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueSignedIdentifier;
        });
    }
}

