/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.client;

import com.azure.core.util.Context;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import java.util.List;
import org.apache.camel.component.azure.storage.queue.client.QueueClientWrapper;
import org.apache.camel.util.ObjectHelper;

public class QueueServiceClientWrapper {
    private final QueueServiceClient client;

    public QueueServiceClientWrapper(QueueServiceClient client) {
        ObjectHelper.notNull(client, "client cannot be null");
        this.client = client;
    }

    public List<QueueItem> listQueues(QueuesSegmentOptions options, Duration timeout) {
        return this.client.listQueues(options, timeout, Context.NONE).stream().toList();
    }

    public QueueClientWrapper getQueueClientWrapper(String queueName) {
        if (!ObjectHelper.isEmpty(queueName)) {
            return new QueueClientWrapper(this.client.getQueueClient(queueName));
        }
        throw new IllegalArgumentException("Cannot initialize a queue since no queue name was provided.");
    }
}

