/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueMessage
implements XmlSerializable<QueueMessage> {
    private String messageText;

    public String getMessageText() {
        return this.messageText;
    }

    public QueueMessage setMessageText(String messageText) {
        this.messageText = messageText;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessage" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("MessageText", this.messageText);
        return xmlWriter.writeEndElement();
    }

    public static QueueMessage fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueMessage.fromXml(xmlReader, null);
    }

    public static QueueMessage fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessage" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueMessage deserializedQueueMessage = new QueueMessage();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("MessageText".equals(elementName.getLocalPart())) {
                    deserializedQueueMessage.messageText = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueMessage;
        });
    }
}

