/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueAccessPolicy
implements XmlSerializable<QueueAccessPolicy> {
    private OffsetDateTime startsOn;
    private OffsetDateTime expiresOn;
    private String permissions;

    public OffsetDateTime getStartsOn() {
        return this.startsOn;
    }

    public QueueAccessPolicy setStartsOn(OffsetDateTime startsOn) {
        this.startsOn = startsOn;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public QueueAccessPolicy setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public QueueAccessPolicy setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueAccessPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Start", this.startsOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startsOn));
        xmlWriter.writeStringElement("Expiry", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        xmlWriter.writeStringElement("Permission", this.permissions);
        return xmlWriter.writeEndElement();
    }

    public static QueueAccessPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueAccessPolicy.fromXml(xmlReader, null);
    }

    public static QueueAccessPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueAccessPolicy" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueAccessPolicy deserializedQueueAccessPolicy = new QueueAccessPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedQueueAccessPolicy.startsOn = reader.getNullableElement(dateString -> OffsetDateTime.parse(dateString));
                    continue;
                }
                if ("Expiry".equals(elementName.getLocalPart())) {
                    deserializedQueueAccessPolicy.expiresOn = reader.getNullableElement(dateString -> OffsetDateTime.parse(dateString));
                    continue;
                }
                if ("Permission".equals(elementName.getLocalPart())) {
                    deserializedQueueAccessPolicy.permissions = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueAccessPolicy;
        });
    }
}

