/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.queue.models.QueueRetentionPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueAnalyticsLogging
implements XmlSerializable<QueueAnalyticsLogging> {
    private String version;
    private boolean delete;
    private boolean read;
    private boolean write;
    private QueueRetentionPolicy retentionPolicy;

    public String getVersion() {
        return this.version;
    }

    public QueueAnalyticsLogging setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public QueueAnalyticsLogging setDelete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public boolean isRead() {
        return this.read;
    }

    public QueueAnalyticsLogging setRead(boolean read) {
        this.read = read;
        return this;
    }

    public boolean isWrite() {
        return this.write;
    }

    public QueueAnalyticsLogging setWrite(boolean write) {
        this.write = write;
        return this;
    }

    public QueueRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public QueueAnalyticsLogging setRetentionPolicy(QueueRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueAnalyticsLogging" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Delete", this.delete);
        xmlWriter.writeBooleanElement("Read", this.read);
        xmlWriter.writeBooleanElement("Write", this.write);
        xmlWriter.writeXml(this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    public static QueueAnalyticsLogging fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueAnalyticsLogging.fromXml(xmlReader, null);
    }

    public static QueueAnalyticsLogging fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueAnalyticsLogging" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueAnalyticsLogging deserializedQueueAnalyticsLogging = new QueueAnalyticsLogging();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedQueueAnalyticsLogging.version = reader.getStringElement();
                    continue;
                }
                if ("Delete".equals(elementName.getLocalPart())) {
                    deserializedQueueAnalyticsLogging.delete = reader.getBooleanElement();
                    continue;
                }
                if ("Read".equals(elementName.getLocalPart())) {
                    deserializedQueueAnalyticsLogging.read = reader.getBooleanElement();
                    continue;
                }
                if ("Write".equals(elementName.getLocalPart())) {
                    deserializedQueueAnalyticsLogging.write = reader.getBooleanElement();
                    continue;
                }
                if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedQueueAnalyticsLogging.retentionPolicy = QueueRetentionPolicy.fromXml(reader, "RetentionPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueAnalyticsLogging;
        });
    }
}

