/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueCorsRule
implements XmlSerializable<QueueCorsRule> {
    private String allowedOrigins;
    private String allowedMethods;
    private String allowedHeaders;
    private String exposedHeaders;
    private int maxAgeInSeconds;

    public String getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public QueueCorsRule setAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public QueueCorsRule setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public QueueCorsRule setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public QueueCorsRule setExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    public int getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public QueueCorsRule setMaxAgeInSeconds(int maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "CorsRule" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("AllowedOrigins", this.allowedOrigins);
        xmlWriter.writeStringElement("AllowedMethods", this.allowedMethods);
        xmlWriter.writeStringElement("AllowedHeaders", this.allowedHeaders);
        xmlWriter.writeStringElement("ExposedHeaders", this.exposedHeaders);
        xmlWriter.writeIntElement("MaxAgeInSeconds", this.maxAgeInSeconds);
        return xmlWriter.writeEndElement();
    }

    public static QueueCorsRule fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueCorsRule.fromXml(xmlReader, null);
    }

    public static QueueCorsRule fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "CorsRule" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueueCorsRule deserializedQueueCorsRule = new QueueCorsRule();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("AllowedOrigins".equals(elementName.getLocalPart())) {
                    deserializedQueueCorsRule.allowedOrigins = reader.getStringElement();
                    continue;
                }
                if ("AllowedMethods".equals(elementName.getLocalPart())) {
                    deserializedQueueCorsRule.allowedMethods = reader.getStringElement();
                    continue;
                }
                if ("AllowedHeaders".equals(elementName.getLocalPart())) {
                    deserializedQueueCorsRule.allowedHeaders = reader.getStringElement();
                    continue;
                }
                if ("ExposedHeaders".equals(elementName.getLocalPart())) {
                    deserializedQueueCorsRule.exposedHeaders = reader.getStringElement();
                    continue;
                }
                if ("MaxAgeInSeconds".equals(elementName.getLocalPart())) {
                    deserializedQueueCorsRule.maxAgeInSeconds = reader.getIntElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueCorsRule;
        });
    }
}

