/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.queue.QueueServiceClient;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueConstants;
import org.apache.camel.component.azure.storage.queue.QueueConsumer;
import org.apache.camel.component.azure.storage.queue.QueueProducer;
import org.apache.camel.component.azure.storage.queue.client.QueueClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.3.0", scheme="azure-storage-queue", title="Azure Storage Queue Service", syntax="azure-storage-queue:accountName/queueName", category={Category.CLOUD, Category.MESSAGING}, headersClass=QueueConstants.class)
public class QueueEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private QueueServiceClient queueServiceClient;
    @UriParam
    private QueueConfiguration configuration;

    public QueueEndpoint(String uri, Component component, QueueConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new QueueProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty(this.configuration.getQueueName())) {
            throw new IllegalArgumentException("QueueName must be set.");
        }
        QueueConsumer consumer = new QueueConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.queueServiceClient = this.configuration.getServiceClient() != null ? this.configuration.getServiceClient() : QueueClientFactory.createQueueServiceClient(this.configuration);
    }

    public QueueConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(QueueConfiguration configuration) {
        this.configuration = configuration;
    }

    public QueueServiceClient getQueueServiceClient() {
        return this.queueServiceClient;
    }

    @Override
    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty(this.configuration.getAccountName()) && ObjectHelper.isNotEmpty(this.configuration.getQueueName())) {
            return "azure-storage-queue:" + this.configuration.getAccountName() + "/" + this.configuration.getQueueName();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "storage-queue";
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getCredentialType() != null) {
            return Map.of("credentialType", this.configuration.getCredentialType().name());
        }
        return null;
    }
}

