/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="azure-storage-queue:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Azure Storage Queue receive message information")
public class AzureStorageQueueCloudEventDataTypeTransformer
extends Transformer {
    @Override
    public void transform(Message message, DataType fromType, DataType toType) {
        Map<String, Object> headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.azure.storage.queue.receiveMessages");
        if (message.getHeaders().containsKey("CamelAzureStorageQueueMessageId")) {
            headers.put("CamelCloudEventSource", "azure.storage.queue." + message.getHeader("CamelAzureStorageQueueMessageId", String.class));
        }
        if (message.getHeaders().containsKey("CamelAzureStorageQueuePopReceipt")) {
            headers.put("CamelCloudEventSubject", message.getHeader("CamelAzureStorageQueuePopReceipt", String.class));
        }
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "text/plain");
    }
}

