/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.IPrivateKeyDecryptor;
import com.box.sdk.JWTEncryptionPreferences;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.Reader;

public class BoxConfig {
    private String clientId;
    private String clientSecret;
    private String enterpriseId;
    private JWTEncryptionPreferences jwtEncryptionPreferences;

    public BoxConfig(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public BoxConfig(String clientId, String clientSecret, String enterpriseId, JWTEncryptionPreferences jwtEncryptionPreferences) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.enterpriseId = enterpriseId;
        this.jwtEncryptionPreferences = jwtEncryptionPreferences;
    }

    public BoxConfig(String clientId, String clientSecret, String enterpriseId, String publicKeyID, String privateKey, String privateKeyPassword, EncryptionAlgorithm encryptionAlgorithm) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.enterpriseId = enterpriseId;
        this.jwtEncryptionPreferences = new JWTEncryptionPreferences();
        this.jwtEncryptionPreferences.setPublicKeyID(publicKeyID);
        this.jwtEncryptionPreferences.setPrivateKey(privateKey);
        this.jwtEncryptionPreferences.setPrivateKeyPassword(privateKeyPassword);
        this.jwtEncryptionPreferences.setEncryptionAlgorithm(encryptionAlgorithm);
    }

    public BoxConfig(String clientId, String clientSecret, String enterpriseId, String publicKeyID, String privateKey, String privateKeyPassword) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.enterpriseId = enterpriseId;
        this.jwtEncryptionPreferences = new JWTEncryptionPreferences();
        this.jwtEncryptionPreferences.setPublicKeyID(publicKeyID);
        this.jwtEncryptionPreferences.setPrivateKey(privateKey);
        this.jwtEncryptionPreferences.setPrivateKeyPassword(privateKeyPassword);
        this.jwtEncryptionPreferences.setEncryptionAlgorithm(EncryptionAlgorithm.RSA_SHA_256);
    }

    public static BoxConfig readFrom(Reader reader) throws IOException {
        return BoxConfig.createConfigFrom(Json.parse(reader).asObject());
    }

    public static BoxConfig readFrom(String jsonString) {
        return BoxConfig.createConfigFrom(Json.parse(jsonString).asObject());
    }

    private static BoxConfig createConfigFrom(JsonObject config) {
        JsonObject settings = (JsonObject)config.get("boxAppSettings");
        String clientId = settings.get("clientID").asString();
        String clientSecret = settings.get("clientSecret").asString();
        JsonObject appAuth = (JsonObject)settings.get("appAuth");
        String publicKeyId = appAuth.get("publicKeyID").asString();
        String privateKey = appAuth.get("privateKey").asString();
        String passphrase = appAuth.get("passphrase").asString();
        String enterpriseId = config.get("enterpriseID").asString();
        return new BoxConfig(clientId, clientSecret, enterpriseId, publicKeyId, privateKey, passphrase);
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public JWTEncryptionPreferences getJWTEncryptionPreferences() {
        return this.jwtEncryptionPreferences;
    }

    public void setJWTEncryptionPreferences(JWTEncryptionPreferences jwtEncryptionPreferences) {
        this.jwtEncryptionPreferences = jwtEncryptionPreferences;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setPrivateKeyDecryptor(IPrivateKeyDecryptor privateKeyDecryptor) {
        this.jwtEncryptionPreferences.setPrivateKeyDecryptor(privateKeyDecryptor);
    }
}

