/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxFile;
import com.eclipsesource.json.JsonObject;

public class BoxSignRequestFile {
    private String fileId;
    private String fileVersionId;

    public BoxSignRequestFile(String fileId, String fileVersionId) {
        this.fileId = fileId;
        this.fileVersionId = fileVersionId;
    }

    public BoxSignRequestFile(String fileId) {
        this.fileId = fileId;
    }

    static BoxSignRequestFile fromFile(BoxFile.Info sourceFile) {
        BoxSignRequestFile file = new BoxSignRequestFile(sourceFile.getID());
        if (sourceFile.getVersion() != null) {
            file.setFileVersionId(sourceFile.getVersionNumber());
        }
        return file;
    }

    public String getFileId() {
        return this.fileId;
    }

    public BoxSignRequestFile setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String getFileVersionId() {
        return this.fileVersionId;
    }

    public BoxSignRequestFile setFileVersionId(String fileVersionId) {
        this.fileVersionId = fileVersionId;
        return this;
    }

    public JsonObject getJSONObject() {
        JsonObject fileJSON = new JsonObject().add("id", this.fileId).add("type", "file");
        if (this.fileVersionId != null) {
            JsonObject fileVersionJSON = new JsonObject();
            fileVersionJSON.add("id", this.fileVersionId);
            fileVersionJSON.add("type", "file_version");
            fileJSON.add("file_version", fileVersionJSON);
        }
        return fileJSON;
    }
}

