/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxCollection;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.sharedlink.BoxSharedLinkWithoutPermissionsRequest;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;

@BoxResourceType(value="web_link")
public class BoxWebLink
extends BoxItem {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "name", "url", "description", "path_collection", "created_at", "modified_at", "trashed_at", "purged_at", "created_by", "modified_by", "owned_by", "shared_link", "parent", "item_status", "collections"};
    public static final URLTemplate COPY_URL_TEMPLATE = new URLTemplate("web_links/%s/copy");
    public static final URLTemplate WEB_LINK_URL_TEMPLATE = new URLTemplate("web_links/%s");

    public BoxWebLink(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public BoxSharedLink createSharedLink(BoxSharedLinkWithoutPermissionsRequest sharedLinkRequest) {
        return this.createSharedLink(sharedLinkRequest.asSharedLink());
    }

    private BoxSharedLink createSharedLink(BoxSharedLink sharedLink) {
        Info info = new Info();
        info.setSharedLink(sharedLink);
        this.updateInfo(info);
        return info.getSharedLink();
    }

    @Override
    public Info copy(BoxFolder destination) {
        return this.copy(destination, null);
    }

    @Override
    public Info copy(BoxFolder destination, String newName) {
        URL url = COPY_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject copyInfo = new JsonObject();
        copyInfo.add("parent", parent);
        if (newName != null) {
            copyInfo.add("name", newName);
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(copyInfo.toString());
        try (BoxJSONResponse response = request.send();){
            BoxWebLink copiedWebLink;
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            BoxWebLink boxWebLink = copiedWebLink = new BoxWebLink(this.getAPI(), responseJSON.get("id").asString());
            boxWebLink.getClass();
            Info info = boxWebLink.new Info(responseJSON);
            return info;
        }
    }

    public void delete() {
        URL url = WEB_LINK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    @Override
    public BoxItem.Info move(BoxFolder destination) {
        return this.move(destination, null);
    }

    @Override
    public BoxItem.Info move(BoxFolder destination, String newName) {
        URL url = WEB_LINK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("parent", parent);
        if (newName != null) {
            updateInfo.add("name", newName);
        }
        request.setBody(updateInfo.toString());
        try (BoxJSONResponse response = request.send();){
            BoxWebLink movedWebLink;
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            BoxWebLink boxWebLink = movedWebLink = new BoxWebLink(this.getAPI(), responseJSON.get("id").asString());
            boxWebLink.getClass();
            Info info = boxWebLink.new Info(responseJSON);
            return info;
        }
    }

    public void rename(String newName) {
        URL url = WEB_LINK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("name", newName);
        request.setBody(updateInfo.toString());
        request.send().close();
    }

    @Override
    public Info getInfo(String ... fields) {
        URL url = WEB_LINK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        if (fields.length > 0) {
            String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
            url = WEB_LINK_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            Info info = new Info(response.getJSON());
            return info;
        }
    }

    public void updateInfo(Info info) {
        URL url = WEB_LINK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
            info.update(jsonObject);
        }
    }

    @Override
    public Info setCollections(BoxCollection ... collections) {
        JsonArray jsonArray = new JsonArray();
        for (BoxCollection collection : collections) {
            JsonObject collectionJSON = new JsonObject();
            collectionJSON.add("id", collection.getID());
            jsonArray.add(collectionJSON);
        }
        JsonObject infoJSON = new JsonObject();
        infoJSON.add("collections", jsonArray);
        String queryString = new QueryStringBuilder().appendParam("fields", ALL_FIELDS).toString();
        URL url = WEB_LINK_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(infoJSON.toString());
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
            Info info = new Info(jsonObject);
            return info;
        }
    }

    public class Info
    extends BoxItem.Info {
        private URL linkURL;
        private String description;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        public Info(JsonObject jsonObject) {
            super(jsonObject.toString());
        }

        @Override
        public BoxWebLink getResource() {
            return BoxWebLink.this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public URL getLinkURL() {
            return this.linkURL;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            block6: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("url")) {
                        try {
                            this.linkURL = value.asString().isEmpty() ? null : new URL(value.asString());
                            break block6;
                        }
                        catch (MalformedURLException e) {
                            throw new BoxAPIException("Couldn't parse url for weblink", e);
                        }
                    }
                    if (memberName.equals("description")) {
                        this.description = value.asString();
                    }
                }
                catch (Exception e) {
                    throw new BoxDeserializationException(memberName, value.toString(), e);
                }
            }
        }
    }
}

