/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxEvent;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.EnterpriseEventsRequest;
import com.box.sdk.EnterpriseEventsStreamRequest;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class EventLog
implements Iterable<BoxEvent> {
    static final int ENTERPRISE_LIMIT = 500;
    public static final URLTemplate ENTERPRISE_EVENT_URL_TEMPLATE = new URLTemplate("events?stream_type=admin_logs&limit=500");
    private final int chunkSize;
    private final int limit;
    private final String nextStreamPosition;
    private final String streamPosition;
    private final Set<BoxEvent> events;
    private Date startDate;
    private Date endDate;

    EventLog(BoxAPIConnection api, JsonObject json, String streamPosition, int limit) {
        this.streamPosition = streamPosition;
        this.limit = limit;
        JsonValue nextStreamPosition = json.get("next_stream_position");
        this.nextStreamPosition = nextStreamPosition.isString() ? nextStreamPosition.asString() : nextStreamPosition.toString();
        this.chunkSize = json.get("chunk_size").asInt();
        this.events = new LinkedHashSet<BoxEvent>(this.chunkSize);
        JsonArray entries = json.get("entries").asArray();
        for (JsonValue entry : entries) {
            this.events.add(new BoxEvent(api, entry.asObject()));
        }
    }

    public static EventLog getEnterpriseEvents(BoxAPIConnection api, EnterpriseEventsRequest enterpriseEventsRequest) {
        EventLogRequest request = new EventLogRequest(enterpriseEventsRequest.getBefore(), enterpriseEventsRequest.getAfter(), enterpriseEventsRequest.getPosition(), enterpriseEventsRequest.getLimit(), enterpriseEventsRequest.getTypes());
        return EventLog.getEnterpriseEventsForStreamType(api, enterpriseEventsRequest.getStreamType(), request);
    }

    public static EventLog getEnterpriseEventsStream(BoxAPIConnection api, EnterpriseEventsStreamRequest enterpriseEventsStreamRequest) {
        EventLogRequest request = new EventLogRequest(null, null, enterpriseEventsStreamRequest.getPosition(), enterpriseEventsStreamRequest.getLimit(), enterpriseEventsStreamRequest.getTypes());
        return EventLog.getEnterpriseEventsForStreamType(api, enterpriseEventsStreamRequest.getStreamType(), request);
    }

    private static EventLog getEnterpriseEventsForStreamType(BoxAPIConnection api, String streamType, EventLogRequest request) {
        URL url = new URLTemplate("events?").build(api.getBaseURL(), new Object[0]);
        QueryStringBuilder queryBuilder = new QueryStringBuilder(url.getQuery());
        queryBuilder.appendParam("stream_type", streamType);
        EventLog.addParamsToQuery(request, queryBuilder);
        try {
            url = queryBuilder.addToURL(url);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException("Couldn't append a query string to the provided URL.");
        }
        BoxJSONRequest apiRequest = new BoxJSONRequest(api, url, "GET");
        try (BoxJSONResponse response = apiRequest.send();){
            JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
            EventLog log = new EventLog(api, responseJSON, request.getPosition(), request.getLimit());
            log.setStartDate(request.getAfter());
            log.setEndDate(request.getBefore());
            EventLog eventLog = log;
            return eventLog;
        }
    }

    private static void addParamsToQuery(EventLogRequest request, QueryStringBuilder queryBuilder) {
        queryBuilder.appendParam("limit", request.getLimit().intValue());
        if (request.getAfter() != null) {
            queryBuilder.appendParam("created_after", BoxDateFormat.format(request.getAfter()));
        }
        if (request.getBefore() != null) {
            queryBuilder.appendParam("created_before", BoxDateFormat.format(request.getBefore()));
        }
        if (request.getPosition() != null) {
            queryBuilder.appendParam("stream_position", request.getPosition());
        }
        if (request.getTypes().size() > 0) {
            String types = String.join((CharSequence)",", request.getTypes());
            queryBuilder.appendParam("event_type", types);
        }
    }

    @Override
    public Iterator<BoxEvent> iterator() {
        return this.events.iterator();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getStreamPosition() {
        return this.streamPosition;
    }

    public String getNextStreamPosition() {
        return this.nextStreamPosition;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getSize() {
        return this.events.size();
    }

    private static final class EventLogRequest {
        private final Date before;
        private final Date after;
        private final String position;
        private final Integer limit;
        private final Collection<String> types;

        private EventLogRequest(Date before, Date after, String position, Integer limit, Collection<String> types) {
            this.before = before;
            this.after = after;
            this.position = position;
            this.limit = limit;
            this.types = types;
        }

        private Date getBefore() {
            return this.before;
        }

        private Date getAfter() {
            return this.after;
        }

        private String getPosition() {
            return this.position;
        }

        private Integer getLimit() {
            return this.limit;
        }

        private Collection<String> getTypes() {
            return this.types;
        }
    }
}

