/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;

class RealtimeServerConnection {
    public static final URLTemplate EVENT_URL = new URLTemplate("events");
    public static final URLTemplate EVENT_POSITION_URL = new URLTemplate("events?stream_position=%s");
    private final BoxAPIConnection api;
    private final int timeout;
    private final String serverURLString;
    private int retries;

    RealtimeServerConnection(BoxAPIConnection api) {
        BoxJSONRequest request = new BoxJSONRequest(api, EVENT_URL.build(api.getBaseURL(), new Object[0]), "OPTIONS");
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
            JsonArray entries = jsonObject.get("entries").asArray();
            JsonObject firstEntry = entries.get(0).asObject();
            this.serverURLString = firstEntry.get("url").asString();
            this.retries = Integer.parseInt(firstEntry.get("max_retries").asString());
            this.timeout = firstEntry.get("retry_timeout").asInt();
            this.api = api;
        }
    }

    int getRemainingRetries() {
        return this.retries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean waitForChange(long position) {
        URL url;
        if (this.retries < 1) {
            throw new IllegalStateException("No more retries are allowed.");
        }
        try {
            String u = this.serverURLString + "&stream_position=" + position;
            url = new URL(u);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException("The long poll URL was malformed.", e);
        }
        while (this.retries > 0) {
            --this.retries;
            BoxJSONRequest request = new BoxJSONRequest(this.api, url, "GET");
            request.setConnectTimeout(this.timeout * 1000);
            request.setReadTimeout(this.timeout * 1000);
            try {
                BoxJSONResponse response = request.send();
                Throwable throwable = null;
                try {
                    JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
                    String message = jsonObject.get("message").asString();
                    if (!message.equals("new_change")) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (BoxAPIException e) {
                return false;
            }
        }
        return false;
    }
}

