/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.IAccessTokenCache;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.box.BoxComponent;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class BoxComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private BoxConfiguration getOrCreateConfiguration(BoxComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new BoxConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        BoxComponent target = (BoxComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstokencache": 
            case "accessTokenCache": {
                this.getOrCreateConfiguration(target).setAccessTokenCache(BoxComponentConfigurer.property(camelContext, IAccessTokenCache.class, value));
                return true;
            }
            case "authenticationtype": 
            case "authenticationType": {
                this.getOrCreateConfiguration(target).setAuthenticationType(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(BoxComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(BoxComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clientsecret": 
            case "clientSecret": {
                this.getOrCreateConfiguration(target).setClientSecret(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(BoxComponentConfigurer.property(camelContext, BoxConfiguration.class, value));
                return true;
            }
            case "encryptionalgorithm": 
            case "encryptionAlgorithm": {
                this.getOrCreateConfiguration(target).setEncryptionAlgorithm(BoxComponentConfigurer.property(camelContext, EncryptionAlgorithm.class, value));
                return true;
            }
            case "enterpriseid": 
            case "enterpriseId": {
                this.getOrCreateConfiguration(target).setEnterpriseId(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpparams": 
            case "httpParams": {
                this.getOrCreateConfiguration(target).setHttpParams(BoxComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(BoxComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxcacheentries": 
            case "maxCacheEntries": {
                this.getOrCreateConfiguration(target).setMaxCacheEntries(BoxComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "privatekeyfile": 
            case "privateKeyFile": {
                this.getOrCreateConfiguration(target).setPrivateKeyFile(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "privatekeypassword": 
            case "privateKeyPassword": {
                this.getOrCreateConfiguration(target).setPrivateKeyPassword(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "publickeyid": 
            case "publicKeyId": {
                this.getOrCreateConfiguration(target).setPublicKeyId(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters(BoxComponentConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "userid": 
            case "userId": {
                this.getOrCreateConfiguration(target).setUserId(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "username": 
            case "userName": {
                this.getOrCreateConfiguration(target).setUserName(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "userpassword": 
            case "userPassword": {
                this.getOrCreateConfiguration(target).setUserPassword(BoxComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstokencache": 
            case "accessTokenCache": {
                return IAccessTokenCache.class;
            }
            case "authenticationtype": 
            case "authenticationType": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "clientsecret": 
            case "clientSecret": {
                return String.class;
            }
            case "configuration": {
                return BoxConfiguration.class;
            }
            case "encryptionalgorithm": 
            case "encryptionAlgorithm": {
                return EncryptionAlgorithm.class;
            }
            case "enterpriseid": 
            case "enterpriseId": {
                return String.class;
            }
            case "httpparams": 
            case "httpParams": {
                return Map.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxcacheentries": 
            case "maxCacheEntries": {
                return Integer.TYPE;
            }
            case "privatekeyfile": 
            case "privateKeyFile": {
                return String.class;
            }
            case "privatekeypassword": 
            case "privateKeyPassword": {
                return String.class;
            }
            case "publickeyid": 
            case "publicKeyId": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "userid": 
            case "userId": {
                return String.class;
            }
            case "username": 
            case "userName": {
                return String.class;
            }
            case "userpassword": 
            case "userPassword": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        BoxComponent target = (BoxComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstokencache": 
            case "accessTokenCache": {
                return this.getOrCreateConfiguration(target).getAccessTokenCache();
            }
            case "authenticationtype": 
            case "authenticationType": {
                return this.getOrCreateConfiguration(target).getAuthenticationType();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "clientsecret": 
            case "clientSecret": {
                return this.getOrCreateConfiguration(target).getClientSecret();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "encryptionalgorithm": 
            case "encryptionAlgorithm": {
                return this.getOrCreateConfiguration(target).getEncryptionAlgorithm();
            }
            case "enterpriseid": 
            case "enterpriseId": {
                return this.getOrCreateConfiguration(target).getEnterpriseId();
            }
            case "httpparams": 
            case "httpParams": {
                return this.getOrCreateConfiguration(target).getHttpParams();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxcacheentries": 
            case "maxCacheEntries": {
                return this.getOrCreateConfiguration(target).getMaxCacheEntries();
            }
            case "privatekeyfile": 
            case "privateKeyFile": {
                return this.getOrCreateConfiguration(target).getPrivateKeyFile();
            }
            case "privatekeypassword": 
            case "privateKeyPassword": {
                return this.getOrCreateConfiguration(target).getPrivateKeyPassword();
            }
            case "publickeyid": 
            case "publicKeyId": {
                return this.getOrCreateConfiguration(target).getPublicKeyId();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "userid": 
            case "userId": {
                return this.getOrCreateConfiguration(target).getUserId();
            }
            case "username": 
            case "userName": {
                return this.getOrCreateConfiguration(target).getUserName();
            }
            case "userpassword": 
            case "userPassword": {
                return this.getOrCreateConfiguration(target).getUserPassword();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "httpparams": 
            case "httpParams": {
                return Object.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("ClientId", String.class);
        map.put("Configuration", BoxConfiguration.class);
        map.put("EnterpriseId", String.class);
        map.put("UserId", String.class);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("AutowiredEnabled", Boolean.TYPE);
        map.put("HttpParams", Map.class);
        map.put("AuthenticationType", String.class);
        map.put("AccessTokenCache", IAccessTokenCache.class);
        map.put("ClientSecret", String.class);
        map.put("EncryptionAlgorithm", EncryptionAlgorithm.class);
        map.put("MaxCacheEntries", Integer.TYPE);
        map.put("PrivateKeyFile", String.class);
        map.put("PrivateKeyPassword", String.class);
        map.put("PublicKeyId", String.class);
        map.put("SslContextParameters", SSLContextParameters.class);
        map.put("UserName", String.class);
        map.put("UserPassword", String.class);
        ALL_OPTIONS = map;
    }
}

