/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxMetadataFilter;
import com.box.sdk.DateRange;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.SizeRange;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.util.List;

public class BoxSearchParameters {
    private String query;
    private List<String> fields;
    private String scope;
    private List<String> fileExtensions;
    private DateRange createdRange;
    private DateRange updatedRange;
    private SizeRange sizeRange;
    private List<String> ownerUserIds;
    private List<String> ancestorFolderIds;
    private List<String> contentTypes;
    private String type;
    private String trashContent;
    private BoxMetadataFilter metadataFilter;
    private String sort;
    private String direction;
    private List<String> deleterUserIds;
    private DateRange deletedRange;

    public BoxSearchParameters() {
    }

    public BoxSearchParameters(String query) {
        this.query = query;
    }

    public boolean clearParameters() {
        this.query = null;
        this.fields = null;
        this.scope = null;
        this.fileExtensions = null;
        this.createdRange = null;
        this.updatedRange = null;
        this.sizeRange = null;
        this.ownerUserIds = null;
        this.ancestorFolderIds = null;
        this.contentTypes = null;
        this.type = null;
        this.trashContent = null;
        this.metadataFilter = null;
        this.sort = null;
        this.direction = null;
        this.deleterUserIds = null;
        this.deletedRange = null;
        return true;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(List<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public DateRange getCreatedRange() {
        return this.createdRange;
    }

    public void setCreatedRange(DateRange createdRange) {
        this.createdRange = createdRange;
    }

    public DateRange getUpdatedRange() {
        return this.updatedRange;
    }

    public void setUpdatedRange(DateRange updatedRange) {
        this.updatedRange = updatedRange;
    }

    public SizeRange getSizeRange() {
        return this.sizeRange;
    }

    public void setSizeRange(SizeRange sizeRange) {
        this.sizeRange = sizeRange;
    }

    public List<String> getOwnerUserIds() {
        return this.ownerUserIds;
    }

    public void setOwnerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
    }

    public List<String> getAncestorFolderIds() {
        return this.ancestorFolderIds;
    }

    public void setAncestorFolderIds(List<String> ancestorFolderIds) {
        this.ancestorFolderIds = ancestorFolderIds;
    }

    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    public void setContentTypes(List<String> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTrashContent() {
        return this.trashContent;
    }

    public void setTrashContent(String trashContent) {
        this.trashContent = trashContent;
    }

    public BoxMetadataFilter getMetadataFilter() {
        return this.metadataFilter;
    }

    public void setMetadataFilter(BoxMetadataFilter metadataFilter) {
        this.metadataFilter = metadataFilter;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sortBy) {
        this.sort = sortBy;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public List<String> getDeleterUserIds() {
        return this.deleterUserIds;
    }

    public void setDeleterUserIds(List<String> deleterUserIds) {
        this.deleterUserIds = deleterUserIds;
    }

    public DateRange getDeletedRange() {
        return this.deletedRange;
    }

    public void setDeletedRange(DateRange deletedRange) {
        this.deletedRange = deletedRange;
    }

    private boolean isNullOrEmpty(Object paramValue) {
        boolean isNullOrEmpty = false;
        if (paramValue == null) {
            isNullOrEmpty = true;
        }
        if (paramValue instanceof String) {
            if (((String)paramValue).trim().equalsIgnoreCase("")) {
                isNullOrEmpty = true;
            }
        } else if (paramValue instanceof List) {
            return ((List)paramValue).isEmpty();
        }
        return isNullOrEmpty;
    }

    private JsonArray formatBoxMetadataFilterRequest() {
        JsonArray boxMetadataFilterRequestArray = new JsonArray();
        JsonObject boxMetadataFilter = new JsonObject().add("templateKey", this.metadataFilter.getTemplateKey()).add("scope", this.metadataFilter.getScope()).add("filters", this.metadataFilter.getFiltersList());
        boxMetadataFilterRequestArray.add(boxMetadataFilter);
        return boxMetadataFilterRequestArray;
    }

    private String listToCSV(List<String> list) {
        String csvStr = "";
        for (String item : list) {
            csvStr = csvStr + "," + item;
        }
        return csvStr.length() > 1 ? csvStr.substring(1) : csvStr;
    }

    public QueryStringBuilder getQueryParameters() {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (this.isNullOrEmpty(this.query) && this.metadataFilter == null) {
            throw new BoxAPIException("BoxSearchParameters requires either a search query or Metadata filter to be set.");
        }
        if (!this.isNullOrEmpty(this.query)) {
            builder.appendParam("query", this.query);
        }
        if (!this.isNullOrEmpty(this.scope)) {
            builder.appendParam("scope", this.scope);
        }
        if (!this.isNullOrEmpty(this.fileExtensions)) {
            builder.appendParam("file_extensions", this.listToCSV(this.fileExtensions));
        }
        if (this.createdRange != null) {
            builder.appendParam("created_at_range", this.createdRange.buildRangeString());
        }
        if (this.updatedRange != null) {
            builder.appendParam("updated_at_range", this.updatedRange.buildRangeString());
        }
        if (this.sizeRange != null) {
            builder.appendParam("size_range", this.sizeRange.buildRangeString());
        }
        if (!this.isNullOrEmpty(this.ownerUserIds)) {
            builder.appendParam("owner_user_ids", this.listToCSV(this.ownerUserIds));
        }
        if (!this.isNullOrEmpty(this.ancestorFolderIds)) {
            builder.appendParam("ancestor_folder_ids", this.listToCSV(this.ancestorFolderIds));
        }
        if (!this.isNullOrEmpty(this.contentTypes)) {
            builder.appendParam("content_types", this.listToCSV(this.contentTypes));
        }
        if (this.type != null) {
            builder.appendParam("type", this.type);
        }
        if (!this.isNullOrEmpty(this.trashContent)) {
            builder.appendParam("trash_content", this.trashContent);
        }
        if (this.metadataFilter != null) {
            builder.appendParam("mdfilters", this.formatBoxMetadataFilterRequest().toString());
        }
        if (!this.isNullOrEmpty(this.fields)) {
            builder.appendParam("fields", this.listToCSV(this.fields));
        }
        if (!this.isNullOrEmpty(this.sort)) {
            builder.appendParam("sort", this.sort);
        }
        if (!this.isNullOrEmpty(this.direction)) {
            builder.appendParam("direction", this.direction);
        }
        if (!this.isNullOrEmpty(this.deleterUserIds)) {
            builder.appendParam("deleter_user_ids", this.listToCSV(this.deleterUserIds));
        }
        if (this.deletedRange != null) {
            builder.appendParam("deleted_range", this.deletedRange.buildRangeString());
        }
        return builder;
    }
}

