/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxSignTemplateAdditionalInfo;
import com.box.sdk.BoxSignTemplateAdditionalInfoRequired;
import com.box.sdk.BoxSignTemplateCustomBranding;
import com.box.sdk.BoxSignTemplateReadySignLink;
import com.box.sdk.BoxSignTemplateSigner;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@BoxResourceType(value="sign_template")
public class BoxSignTemplate
extends BoxResource {
    public static final URLTemplate SIGN_TEMPLATES_URL_TEMPLATE = new URLTemplate("sign_templates");
    public static final URLTemplate SIGN_TEMPLATE_URL_TEMPLATE = new URLTemplate("sign_templates/%s");
    public static final int DEFAULT_LIMIT = 100;

    public BoxSignTemplate(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api) {
        return BoxSignTemplate.getAll(api, 100);
    }

    public static Iterable<Info> getAll(final BoxAPIConnection api, int limit) {
        QueryStringBuilder builder = new QueryStringBuilder();
        URL url = SIGN_TEMPLATES_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        return new BoxResourceIterable<Info>(api, url, limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxSignTemplate template;
                BoxSignTemplate boxSignTemplate = template = new BoxSignTemplate(api, jsonObject.get("id").asString());
                boxSignTemplate.getClass();
                return boxSignTemplate.new Info(jsonObject);
            }
        };
    }

    public Info getInfo() {
        URL url = SIGN_TEMPLATE_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = (BoxJSONResponse)request.send();){
            JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
            Info info = new Info(jsonObject);
            return info;
        }
    }

    public class Info
    extends BoxResource.Info {
        private BoxSignTemplateAdditionalInfo additionalInfo;
        private boolean areEmailSettingsLocked;
        private boolean areFieldsLocked;
        private boolean areOptionsLocked;
        private boolean areFilesLocked;
        private boolean areRecipientsLocked;
        private BoxSignTemplateCustomBranding customBranding;
        private Integer daysValid;
        private String emailMessage;
        private String emailSubject;
        private String name;
        private BoxFolder.Info parentFolder;
        private BoxSignTemplateReadySignLink readySignLink;
        private List<BoxSignTemplateSigner> signers;
        private List<BoxFile.Info> sourceFiles;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxSignTemplate getResource() {
            return BoxSignTemplate.this;
        }

        public BoxSignTemplateAdditionalInfo getAdditionalInfo() {
            return this.additionalInfo;
        }

        public boolean getAreEmailSettingsLocked() {
            return this.areEmailSettingsLocked;
        }

        public boolean getAreFieldsLocked() {
            return this.areFieldsLocked;
        }

        public boolean getAreOptionsLocked() {
            return this.areOptionsLocked;
        }

        public boolean getAreFilesLocked() {
            return this.areFilesLocked;
        }

        public boolean getAreRecipientsLocked() {
            return this.areRecipientsLocked;
        }

        public BoxSignTemplateCustomBranding getCustomBranding() {
            return this.customBranding;
        }

        public Integer getDaysValid() {
            return this.daysValid;
        }

        public String getEmailMessage() {
            return this.emailMessage;
        }

        public String getEmailSubject() {
            return this.emailSubject;
        }

        public String getName() {
            return this.name;
        }

        public BoxFolder.Info getParentFolder() {
            return this.parentFolder;
        }

        public BoxSignTemplateReadySignLink getReadySignLink() {
            return this.readySignLink;
        }

        public List<BoxSignTemplateSigner> getSigners() {
            return this.signers;
        }

        public List<BoxFile.Info> getSourceFiles() {
            return this.sourceFiles;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                switch (memberName) {
                    case "additional_info": {
                        this.additionalInfo = this.parseAdditionalInfo(value.asObject());
                        break;
                    }
                    case "are_email_settings_locked": {
                        this.areEmailSettingsLocked = value.asBoolean();
                        break;
                    }
                    case "are_fields_locked": {
                        this.areFieldsLocked = value.asBoolean();
                        break;
                    }
                    case "are_options_locked": {
                        this.areOptionsLocked = value.asBoolean();
                        break;
                    }
                    case "are_files_locked": {
                        this.areFilesLocked = value.asBoolean();
                        break;
                    }
                    case "are_recipients_locked": {
                        this.areRecipientsLocked = value.asBoolean();
                        break;
                    }
                    case "custom_branding": {
                        this.customBranding = this.parseCustomBranding(value.asObject());
                        break;
                    }
                    case "days_valid": {
                        this.daysValid = value.asInt();
                        break;
                    }
                    case "email_message": {
                        this.emailMessage = value.asString();
                        break;
                    }
                    case "email_subject": {
                        this.emailSubject = value.asString();
                        break;
                    }
                    case "name": {
                        this.name = value.asString();
                        break;
                    }
                    case "parent_folder": {
                        BoxFolder parentFolder;
                        JsonObject parentFolderJSON = value.asObject();
                        String parentFolderID = parentFolderJSON.get("id").asString();
                        BoxFolder boxFolder = parentFolder = new BoxFolder(BoxSignTemplate.this.getAPI(), parentFolderID);
                        boxFolder.getClass();
                        this.parentFolder = boxFolder.new BoxFolder.Info(parentFolderJSON);
                        break;
                    }
                    case "ready_sign_link": {
                        this.readySignLink = this.parseReadySignLink(value.asObject());
                        break;
                    }
                    case "signers": {
                        this.signers = this.parseSigners(value.asArray());
                        break;
                    }
                    case "source_files": {
                        this.sourceFiles = this.parseSourceFiles(value.asArray());
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private BoxSignTemplateAdditionalInfo parseAdditionalInfo(JsonValue additionalInfoJSON) {
            ArrayList<String> nonEditableFields = new ArrayList<String>();
            for (JsonValue fieldJSON : additionalInfoJSON.asObject().get("non_editable").asArray()) {
                nonEditableFields.add(fieldJSON.asString());
            }
            BoxSignTemplateAdditionalInfoRequired required = this.parseAdditionalInfoRequired(additionalInfoJSON.asObject().get("required").asObject());
            return new BoxSignTemplateAdditionalInfo(nonEditableFields, required);
        }

        private BoxSignTemplateAdditionalInfoRequired parseAdditionalInfoRequired(JsonObject requiredJSON) {
            ArrayList<List<String>> signers = new ArrayList<List<String>>();
            for (JsonValue signerJSON : requiredJSON.get("signers").asArray()) {
                ArrayList<String> signer = new ArrayList<String>();
                for (JsonValue fieldJSON : signerJSON.asArray()) {
                    signer.add(fieldJSON.asString());
                }
                signers.add(signer);
            }
            return new BoxSignTemplateAdditionalInfoRequired(signers);
        }

        private List<BoxFile.Info> parseSourceFiles(JsonValue filesArray) {
            ArrayList<BoxFile.Info> files = new ArrayList<BoxFile.Info>();
            for (JsonValue fileJSON : filesArray.asArray()) {
                BoxFile file;
                JsonObject fileObj = fileJSON.asObject();
                String fileID = fileObj.get("id").asString();
                BoxFile boxFile = file = new BoxFile(BoxSignTemplate.this.getAPI(), fileID);
                boxFile.getClass();
                files.add(boxFile.new BoxFile.Info(fileObj));
            }
            return files;
        }

        private List<BoxSignTemplateSigner> parseSigners(JsonValue signersArray) {
            ArrayList<BoxSignTemplateSigner> signers = new ArrayList<BoxSignTemplateSigner>();
            for (JsonValue signerJSON : signersArray.asArray()) {
                JsonObject signerObj = signerJSON.asObject();
                signers.add(new BoxSignTemplateSigner(signerObj, BoxSignTemplate.this.getAPI()));
            }
            return signers;
        }

        private BoxSignTemplateCustomBranding parseCustomBranding(JsonObject customBrandingJSON) {
            String brandingColor = customBrandingJSON.get("branding_color").asString();
            String companyName = customBrandingJSON.get("company_name").asString();
            String emailFooterText = customBrandingJSON.get("email_footer_text").asString();
            String logoUri = customBrandingJSON.get("logo_uri").asString();
            return new BoxSignTemplateCustomBranding(brandingColor, companyName, emailFooterText, logoUri);
        }

        private BoxSignTemplateReadySignLink parseReadySignLink(JsonObject readySignLinkJSON) {
            String folderID = readySignLinkJSON.get("folder_id").asString();
            String instructions = readySignLinkJSON.get("instructions").asString();
            boolean isActive = readySignLinkJSON.get("is_active").asBoolean();
            boolean isNofiticationDisabled = readySignLinkJSON.get("is_notification_disabled").asBoolean();
            String name = readySignLinkJSON.get("name").asString();
            String url = readySignLinkJSON.get("url").asString();
            return new BoxSignTemplateReadySignLink(folderID, instructions, isActive, isNofiticationDisabled, name, url);
        }
    }
}

