/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class URLTemplate {
    private static final Pattern NUMERIC = Pattern.compile("^[0-9]*$");
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("^[a-zA-Z0-9!@#$%^&*()_+\\-]*$");
    private final String template;

    public URLTemplate(String template) {
        this.template = template;
    }

    public URL build(String base, Object ... values2) {
        for (Object value : values2) {
            String valueString = String.valueOf(value);
            if (NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path parameter passed in. It must be numeric.");
        }
        try {
            return new URL(String.format(this.fullTemplate(base), values2));
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException(e.getMessage());
        }
    }

    public URL buildAlpha(String base, Object ... values2) {
        for (Object value : values2) {
            String valueString = String.valueOf(value);
            Boolean test = ALPHA_NUMERIC.matcher(valueString).matches();
            if (ALPHA_NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path parameter passed in. It must be alphanumeric.");
        }
        try {
            return new URL(String.format(this.fullTemplate(base), values2));
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException(e.getMessage());
        }
    }

    public URL buildWithQuery(String base, String queryString, Object ... values2) {
        for (Object value : values2) {
            String valueString = String.valueOf(value);
            if (NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path param passed in. It must be numeric.");
        }
        try {
            String urlString = String.format(this.fullTemplate(base), values2) + queryString;
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException(e.getMessage());
        }
    }

    public URL buildAlphaWithQuery(String base, String queryString, Object ... values2) {
        for (Object value : values2) {
            String valueString = String.valueOf(value);
            if (ALPHA_NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path param passed in. It must be alphanumeric.");
        }
        try {
            String urlString = String.format(this.fullTemplate(base), values2) + queryString;
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException(e.getMessage());
        }
    }

    private String fullTemplate(String path) {
        return path + this.template;
    }
}

