/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxEvent;
import com.box.sdk.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxEndpoint;
import org.apache.camel.component.box.api.BoxEventsManager;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxConsumer
extends AbstractApiConsumer<BoxApiName, BoxConfiguration>
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BoxConsumer.class);
    private static final String LISTENER_PROPERTY = "listener";
    private BoxAPIConnection boxConnection;
    private BoxEventsManager apiProxy;
    private final ApiMethod apiMethod;
    private final Map<String, Object> properties;

    public BoxConsumer(BoxEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.apiMethod = ApiConsumerHelper.findMethod(endpoint, this);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(endpoint.getEndpointProperties());
        this.properties.put(LISTENER_PROPERTY, this);
    }

    @Override
    public void interceptPropertyNames(Set<String> propertyNames) {
        propertyNames.add(LISTENER_PROPERTY);
    }

    @Override
    public void onEvent(BoxEvent event) {
        try {
            ApiConsumerHelper.getResultsProcessed(this, event, false);
        }
        catch (Exception e) {
            LOG.warn("Received exception consuming event: ", (Throwable)e);
        }
    }

    @Override
    public void onNextPosition(long position) {
    }

    @Override
    public boolean onException(Throwable e) {
        this.getExceptionHandler().handleException(RuntimeCamelException.wrapRuntimeCamelException(e));
        return true;
    }

    @Override
    public BoxEndpoint getEndpoint() {
        return (BoxEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.boxConnection = this.getEndpoint().getBoxConnection();
        this.apiProxy = new BoxEventsManager(this.boxConnection);
        ApiMethodHelper.invokeMethod(this.apiProxy, this.apiMethod, this.properties);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.apiProxy != null) {
            this.apiProxy.stopListening();
        }
        super.doStop();
    }
}

