/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.sharedlink.BoxSharedLinkRequest;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.api.BoxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxFoldersManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxFoldersManager.class);
    private BoxAPIConnection boxConnection;

    public BoxFoldersManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxFolder getRootFolder() {
        try {
            LOG.debug("Getting root folder");
            return BoxFolder.getRootFolder(this.boxConnection);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder getFolder(String ... path) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting folder at path={}", (Object)Arrays.toString(path));
            }
            BoxFolder folder = BoxFolder.getRootFolder(this.boxConnection);
            if (path == null || path.length == 0) {
                return folder;
            }
            for (int folderIndex = 0; folderIndex < path.length; ++folderIndex) {
                BoxItem.Info itemInfo2;
                block6: {
                    for (BoxItem.Info itemInfo2 : folder) {
                        if (!(itemInfo2 instanceof BoxFolder.Info) || !itemInfo2.getName().equals(path[folderIndex])) continue;
                        break block6;
                    }
                    return null;
                }
                folder = (BoxFolder)itemInfo2.getResource();
            }
            return folder;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public Collection<BoxItem.Info> getFolderItems(String folderId, Long offset, Long limit, String ... fields) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting folder items in folder(id={}) at offset={} and limit={} with fields={}", new Object[]{folderId, offset, limit, Arrays.toString(fields)});
            }
            BoxHelper.notNull(folderId, "folderId");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            if (fields == null) {
                fields = new String[]{};
            }
            if (offset != null && limit != null) {
                return folder.getChildrenRange(offset, limit, fields);
            }
            ArrayList<BoxItem.Info> folderItems = new ArrayList<BoxItem.Info>();
            Iterable<BoxItem.Info> iterable = fields.length > 0 ? folder.getChildren(fields) : folder.getChildren();
            for (BoxItem.Info itemInfo : iterable) {
                folderItems.add(itemInfo);
            }
            return folderItems;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder createFolder(String parentFolderId, String folderName) {
        try {
            LOG.debug("Creating folder with name '{}' in parent_folder(id={})", (Object)folderName, (Object)parentFolderId);
            BoxHelper.notNull(parentFolderId, "parentFolderId");
            BoxHelper.notNull(folderName, "folderName");
            BoxFolder parentFolder = new BoxFolder(this.boxConnection, parentFolderId);
            return parentFolder.createFolder(folderName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder createFolder(String parentFolderId, String ... path) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating folder with path '{}' in parent_folder(id={})", (Object)Arrays.toString(path), (Object)parentFolderId);
            }
            BoxHelper.notNull(parentFolderId, "parentFolderId");
            BoxHelper.notNull(path, "path");
            BoxFolder folder = new BoxFolder(this.boxConnection, parentFolderId);
            block2: for (int folderIndex = 0; folderIndex < path.length; ++folderIndex) {
                for (BoxItem.Info itemInfo : folder) {
                    if (!(itemInfo instanceof BoxFolder.Info) || !itemInfo.getName().equals(path[folderIndex])) continue;
                    folder = (BoxFolder)itemInfo.getResource();
                    continue block2;
                }
                folder = folder.createFolder(path[folderIndex]).getResource();
            }
            return folder;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder copyFolder(String folderId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Copying folder(id={}) to destination_folder(id={}) {}", new Object[]{folderId, destinationFolderId, newName == null ? "" : " with new name '" + newName + "'"});
            BoxHelper.notNull(folderId, "folderId");
            BoxHelper.notNull(destinationFolderId, "destinationFolderId");
            BoxFolder folderToCopy = new BoxFolder(this.boxConnection, folderId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return folderToCopy.copy(destinationFolder).getResource();
            }
            return folderToCopy.copy(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder moveFolder(String folderId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Moving folder(id={}) to destination_folder(id={}) {}", new Object[]{folderId, destinationFolderId, newName == null ? "" : " with new name '" + newName + "'"});
            BoxHelper.notNull(folderId, "folderId");
            BoxHelper.notNull(destinationFolderId, "destinationFolderId");
            BoxFolder folderToMove = new BoxFolder(this.boxConnection, folderId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return (BoxFolder)folderToMove.move(destinationFolder).getResource();
            }
            return (BoxFolder)folderToMove.move(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder renameFolder(String folderId, String newFolderName) {
        try {
            LOG.debug("Renaming folder(id={}}) to '{}'", (Object)folderId, (Object)newFolderName);
            BoxHelper.notNull(folderId, "folderId");
            BoxHelper.notNull(newFolderName, "newFolderName");
            BoxFolder folderToRename = new BoxFolder(this.boxConnection, folderId);
            folderToRename.rename(newFolderName);
            return folderToRename;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public void deleteFolder(String folderId) {
        try {
            LOG.debug("Deleting folder(id={})", (Object)folderId);
            BoxHelper.notNull(folderId, "folderId");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            folder.delete(true);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder.Info getFolderInfo(String folderId, String ... fields) {
        try {
            LOG.debug("Getting info for folder(id={})", (Object)folderId);
            BoxHelper.notNull(folderId, "folderId");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            if (fields == null || fields.length == 0) {
                return folder.getInfo(new String[0]);
            }
            return folder.getInfo(fields);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxFolder updateFolderInfo(String folderId, BoxFolder.Info info) {
        try {
            LOG.debug("Updating info for folder(id={})", (Object)folderId);
            BoxHelper.notNull(folderId, "folderId");
            BoxHelper.notNull(info, "info");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            folder.updateInfo(info);
            return folder;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }

    public BoxSharedLink createFolderSharedLink(String folderId, BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions) {
        try {
            LOG.debug("Creating shared link for folder(id={}) with access={} {}", new Object[]{folderId, access, unshareDate == null ? "" : " unsharedDate=" + DateFormat.getDateTimeInstance().format(unshareDate) + " permissions=" + String.valueOf(permissions)});
            BoxHelper.notNull(folderId, "folderId");
            BoxHelper.notNull(access, "access");
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            BoxSharedLinkRequest request = new BoxSharedLinkRequest();
            ((BoxSharedLinkRequest)((BoxSharedLinkRequest)request.access(access)).unsharedDate(unshareDate)).permissions(permissions.getCanDownload(), permissions.getCanPreview(), permissions.getCanEdit());
            return folder.createSharedLink(request);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), e);
        }
    }
}

