/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.condition;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.CqlSnippet;
import com.datastax.oss.driver.api.querybuilder.condition.ConditionBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.condition.DefaultConditionBuilder;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnComponentLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.lhs.FieldLeftOperand;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface Condition
extends CqlSnippet {
    @NonNull
    public static ConditionBuilder<Condition> column(@NonNull CqlIdentifier columnId) {
        return new DefaultConditionBuilder(new ColumnLeftOperand(columnId));
    }

    @NonNull
    public static ConditionBuilder<Condition> column(@NonNull String columnName) {
        return Condition.column(CqlIdentifier.fromCql(columnName));
    }

    @NonNull
    public static ConditionBuilder<Condition> field(@NonNull CqlIdentifier columnId, @NonNull CqlIdentifier fieldId) {
        return new DefaultConditionBuilder(new FieldLeftOperand(columnId, fieldId));
    }

    @NonNull
    public static ConditionBuilder<Condition> field(@NonNull String columnName, @NonNull String fieldName) {
        return Condition.field(CqlIdentifier.fromCql(columnName), CqlIdentifier.fromCql(fieldName));
    }

    @NonNull
    public static ConditionBuilder<Condition> element(@NonNull CqlIdentifier columnId, @NonNull Term index) {
        return new DefaultConditionBuilder(new ColumnComponentLeftOperand(columnId, index));
    }

    @NonNull
    public static ConditionBuilder<Condition> element(@NonNull String columnName, @NonNull Term index) {
        return Condition.element(CqlIdentifier.fromCql(columnName), index);
    }
}

