/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.schema.CreateIndex;
import com.datastax.oss.driver.api.querybuilder.schema.CreateIndexOnTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateIndexStart;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateIndex
implements CreateIndexStart,
CreateIndexOnTable,
CreateIndex {
    private static final String NO_INDEX_TYPE = "__NO_INDEX_TYPE";
    private final CqlIdentifier indexName;
    private final boolean ifNotExists;
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;
    private final ImmutableMap<CqlIdentifier, String> columnToIndexType;
    private final String usingClass;
    private final ImmutableMap<String, Object> options;

    public DefaultCreateIndex() {
        this(null);
    }

    public DefaultCreateIndex(@Nullable CqlIdentifier indexName) {
        this(indexName, false, null, null, ImmutableMap.of(), null, ImmutableMap.of());
    }

    public DefaultCreateIndex(@Nullable CqlIdentifier indexName, boolean ifNotExists, @Nullable CqlIdentifier keyspace, @Nullable CqlIdentifier table, @NonNull ImmutableMap<CqlIdentifier, String> columnToIndexType, @Nullable String usingClass, @NonNull ImmutableMap<String, Object> options) {
        this.indexName = indexName;
        this.ifNotExists = ifNotExists;
        this.keyspace = keyspace;
        this.table = table;
        this.columnToIndexType = columnToIndexType;
        this.usingClass = usingClass;
        this.options = options;
    }

    @Override
    @NonNull
    public CreateIndex andColumn(@NonNull CqlIdentifier column, @Nullable String indexType) {
        if (indexType == null) {
            indexType = NO_INDEX_TYPE;
        }
        return new DefaultCreateIndex(this.indexName, this.ifNotExists, this.keyspace, this.table, ImmutableCollections.append(this.columnToIndexType, column, indexType), this.usingClass, this.options);
    }

    @Override
    @NonNull
    public CreateIndexStart ifNotExists() {
        return new DefaultCreateIndex(this.indexName, true, this.keyspace, this.table, this.columnToIndexType, this.usingClass, this.options);
    }

    @Override
    @NonNull
    public CreateIndexStart custom(@NonNull String className) {
        return new DefaultCreateIndex(this.indexName, this.ifNotExists, this.keyspace, this.table, this.columnToIndexType, className, this.options);
    }

    @Override
    @NonNull
    public CreateIndexOnTable onTable(CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        return new DefaultCreateIndex(this.indexName, this.ifNotExists, keyspace, table, this.columnToIndexType, this.usingClass, this.options);
    }

    @Override
    @NonNull
    public CreateIndex withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultCreateIndex(this.indexName, this.ifNotExists, this.keyspace, this.table, this.columnToIndexType, this.usingClass, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("CREATE ");
        if (this.usingClass != null) {
            builder.append("CUSTOM ");
        }
        builder.append("INDEX");
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (this.indexName != null) {
            builder.append(' ').append(this.indexName.asCql(true));
        }
        if (this.table == null) {
            return builder.toString();
        }
        builder.append(" ON ");
        CqlHelper.qualify(this.keyspace, this.table, builder);
        if (this.columnToIndexType.isEmpty()) {
            return builder.toString();
        }
        builder.append(" (");
        boolean firstColumn = true;
        for (Map.Entry entry : this.columnToIndexType.entrySet()) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                builder.append(",");
            }
            if (((String)entry.getValue()).equals(NO_INDEX_TYPE)) {
                builder.append(entry.getKey());
                continue;
            }
            builder.append((String)entry.getValue()).append("(").append(entry.getKey()).append(")");
        }
        builder.append(")");
        if (this.usingClass != null) {
            builder.append(" USING '").append(this.usingClass).append('\'');
        }
        if (!this.options.isEmpty()) {
            builder.append(OptionsUtils.buildOptions(this.options, true));
        }
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public CqlIdentifier getIndex() {
        return this.indexName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Nullable
    public CqlIdentifier getTable() {
        return this.table;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, String> getColumnToIndexType() {
        return this.columnToIndexType;
    }

    @Nullable
    public String getUsingClass() {
        return this.usingClass;
    }
}

