/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspaceStart;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateKeyspace
implements CreateKeyspace,
CreateKeyspaceStart {
    private final CqlIdentifier keyspaceName;
    private final boolean ifNotExists;
    private final ImmutableMap<String, Object> options;

    public DefaultCreateKeyspace(@NonNull CqlIdentifier keyspaceName) {
        this(keyspaceName, false, ImmutableMap.of());
    }

    public DefaultCreateKeyspace(@NonNull CqlIdentifier keyspaceName, boolean ifNotExists, @NonNull ImmutableMap<String, Object> options) {
        this.keyspaceName = keyspaceName;
        this.ifNotExists = ifNotExists;
        this.options = options;
    }

    @Override
    @NonNull
    public CreateKeyspace withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultCreateKeyspace(this.keyspaceName, this.ifNotExists, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public CreateKeyspaceStart ifNotExists() {
        return new DefaultCreateKeyspace(this.keyspaceName, true, this.options);
    }

    @Override
    @NonNull
    public CreateKeyspace withReplicationOptions(@NonNull Map<String, Object> replicationOptions) {
        return this.withOption("replication", replicationOptions);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE KEYSPACE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(this.keyspaceName.asCql(true));
        builder.append(OptionsUtils.buildOptions(this.options, true));
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspaceName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }
}

