/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.truncate;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;

public class DefaultTruncate
implements Truncate {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;

    public DefaultTruncate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        this.keyspace = keyspace;
        this.table = table;
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("TRUNCATE ");
        CqlHelper.qualify(this.keyspace, this.table, builder);
        return builder.toString();
    }

    @Override
    @NonNull
    public SimpleStatementBuilder builder() {
        return (SimpleStatementBuilder)SimpleStatement.builder(this.asCql()).setIdempotence(true);
    }

    @Override
    @NonNull
    public SimpleStatement build(Object ... values) {
        throw new UnsupportedOperationException("TRUNCATE doesn't take values as parameters. Use build() method instead.");
    }

    @Override
    @NonNull
    public SimpleStatement build(@NonNull Map<String, Object> namedValues) {
        throw new UnsupportedOperationException("TRUNCATE doesn't take namedValues as parameters. Use build() method instead.");
    }

    @Override
    @NonNull
    public SimpleStatement build() {
        return this.builder().build();
    }
}

