/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.querybuilder;

import com.datastax.dse.driver.api.querybuilder.schema.AlterDseKeyspaceStart;
import com.datastax.dse.driver.api.querybuilder.schema.AlterDseTableStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseAggregateStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseFunctionStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseKeyspaceStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseTableStart;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultAlterDseKeyspace;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultAlterDseTable;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultCreateDseAggregate;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultCreateDseFunction;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultCreateDseKeyspace;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultCreateDseTable;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateAggregateStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionStart;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class DseSchemaBuilder
extends SchemaBuilder {
    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@NonNull CqlIdentifier aggregateId) {
        return new DefaultCreateDseAggregate(aggregateId);
    }

    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier aggregateId) {
        return new DefaultCreateDseAggregate(keyspaceId, aggregateId);
    }

    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@NonNull String aggregateName) {
        return new DefaultCreateDseAggregate(CqlIdentifier.fromCql(aggregateName));
    }

    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@Nullable String keyspaceName, @NonNull String aggregateName) {
        return new DefaultCreateDseAggregate(keyspaceName == null ? null : CqlIdentifier.fromCql(keyspaceName), CqlIdentifier.fromCql(aggregateName));
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@NonNull CqlIdentifier aggregateName) {
        return SchemaBuilder.createAggregate(aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier aggregateName) {
        return SchemaBuilder.createAggregate(keyspace, aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@NonNull String aggregateName) {
        return SchemaBuilder.createAggregate(aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@Nullable String keyspace, @NonNull String aggregateName) {
        return SchemaBuilder.createAggregate(keyspace, aggregateName);
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@NonNull CqlIdentifier functionId) {
        return new DefaultCreateDseFunction(functionId);
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId) {
        return new DefaultCreateDseFunction(keyspaceId, functionId);
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@NonNull String functionName) {
        return new DefaultCreateDseFunction(CqlIdentifier.fromCql(functionName));
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@Nullable String keyspaceName, @NonNull String functionName) {
        return new DefaultCreateDseFunction(keyspaceName == null ? null : CqlIdentifier.fromCql(keyspaceName), CqlIdentifier.fromCql(functionName));
    }

    @NonNull
    public static CreateFunctionStart createFunction(@NonNull CqlIdentifier functionName) {
        return SchemaBuilder.createFunction(functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName) {
        return SchemaBuilder.createFunction(keyspace, functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@NonNull String functionName) {
        return SchemaBuilder.createFunction(functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@Nullable String keyspace, @NonNull String functionName) {
        return SchemaBuilder.createFunction(keyspace, functionName);
    }

    @NonNull
    public static CreateDseKeyspaceStart createDseKeyspace(@NonNull CqlIdentifier keyspaceName) {
        return new DefaultCreateDseKeyspace(keyspaceName);
    }

    @NonNull
    public static CreateDseKeyspaceStart createDseKeyspace(@NonNull String keyspaceName) {
        return DseSchemaBuilder.createDseKeyspace(CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public static AlterDseKeyspaceStart alterDseKeyspace(@NonNull CqlIdentifier keyspaceName) {
        return new DefaultAlterDseKeyspace(keyspaceName);
    }

    @NonNull
    public static AlterDseKeyspaceStart alterDseKeyspace(@NonNull String keyspaceName) {
        return DseSchemaBuilder.alterDseKeyspace(CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public static CreateDseTableStart createDseTable(@NonNull CqlIdentifier tableName) {
        return DseSchemaBuilder.createDseTable(null, tableName);
    }

    @NonNull
    public static CreateDseTableStart createDseTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        return new DefaultCreateDseTable(keyspace, tableName);
    }

    @NonNull
    public static CreateDseTableStart createDseTable(@NonNull String tableName) {
        return DseSchemaBuilder.createDseTable(CqlIdentifier.fromCql(tableName));
    }

    @NonNull
    public static CreateDseTableStart createDseTable(@Nullable String keyspace, @NonNull String tableName) {
        return DseSchemaBuilder.createDseTable(keyspace == null ? null : CqlIdentifier.fromCql(keyspace), CqlIdentifier.fromCql(tableName));
    }

    @NonNull
    public static AlterDseTableStart alterDseTable(@NonNull CqlIdentifier tableName) {
        return new DefaultAlterDseTable(tableName);
    }

    @NonNull
    public static AlterDseTableStart alterDseTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        return new DefaultAlterDseTable(keyspace, tableName);
    }

    @NonNull
    public static AlterDseTableStart alterDseTable(@NonNull String tableName) {
        return DseSchemaBuilder.alterDseTable(CqlIdentifier.fromCql(tableName));
    }

    @NonNull
    public static AlterDseTableStart alterDseTable(@Nullable String keyspace, @NonNull String tableName) {
        return DseSchemaBuilder.alterDseTable(keyspace == null ? null : CqlIdentifier.fromCql(keyspace), CqlIdentifier.fromCql(tableName));
    }
}

